/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef;

import com.google.common.io.InputSupplier;
import com.google.inject.ImplementedBy;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.domain.BootstrapConfig;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.Environment;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.internal.BaseChefService;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.scriptbuilder.domain.Statement;

@ImplementedBy(value=BaseChefService.class)
public interface ChefService {
    public ChefContext getContext();

    public byte[] encrypt(InputSupplier<? extends InputStream> var1) throws IOException;

    public byte[] decrypt(InputSupplier<? extends InputStream> var1) throws IOException;

    public Statement createBootstrapScriptForGroup(String var1);

    public Statement createBootstrapScriptForGroup(String var1, @Nullable String var2);

    public void updateBootstrapConfigForGroup(String var1, BootstrapConfig var2);

    @Deprecated
    public List<String> getRunListForGroup(String var1);

    public BootstrapConfig getBootstrapConfigForGroup(String var1);

    public Node createNodeAndPopulateAutomaticAttributes(String var1, Iterable<String> var2);

    public void updateAutomaticAttributesOnNode(String var1);

    public void cleanupStaleNodesAndClients(String var1, int var2);

    public void deleteAllNodesInList(Iterable<String> var1);

    public void deleteAllClientsInList(Iterable<String> var1);

    public Iterable<? extends Node> listNodes();

    public Iterable<? extends Node> listNodes(ExecutorService var1);

    @SinceApiVersion(value="0.10.0")
    public Iterable<? extends Node> listNodesInEnvironment(String var1);

    @SinceApiVersion(value="0.10.0")
    public Iterable<? extends Node> listNodesInEnvironment(String var1, ExecutorService var2);

    public Iterable<? extends Client> listClients();

    public Iterable<? extends Client> listClients(ExecutorService var1);

    public Iterable<? extends CookbookVersion> listCookbookVersions();

    public Iterable<? extends CookbookVersion> listCookbookVersions(ExecutorService var1);

    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String var1);

    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String var1, ExecutorService var2);

    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String var1, String var2);

    public Iterable<? extends CookbookVersion> listCookbookVersionsInEnvironment(String var1, String var2, ExecutorService var3);

    @SinceApiVersion(value="0.10.0")
    public Iterable<? extends Environment> listEnvironments();
}

