/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;

public class AccountMetadata {
    private final long containerCount;
    private final long bytes;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAccountMetadata(this);
    }

    @ConstructorProperties(value={"containerCount", "bytes"})
    protected AccountMetadata(long containerCount, long bytes) {
        this.containerCount = containerCount;
        this.bytes = bytes;
    }

    public long getContainerCount() {
        return this.containerCount;
    }

    public long getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.containerCount, this.bytes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccountMetadata that = (AccountMetadata)AccountMetadata.class.cast(obj);
        return Objects.equal((Object)this.containerCount, (Object)that.containerCount) && Objects.equal((Object)this.bytes, (Object)that.bytes);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("containerCount", this.containerCount).add("bytes", this.bytes);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long containerCount;
        protected long bytes;

        protected abstract T self();

        public T containerCount(long containerCount) {
            this.containerCount = containerCount;
            return this.self();
        }

        public T bytes(long bytes) {
            this.bytes = bytes;
            return this.self();
        }

        public AccountMetadata build() {
            return new AccountMetadata(this.containerCount, this.bytes);
        }

        public T fromAccountMetadata(AccountMetadata in) {
            return ((Builder)this.containerCount(in.getContainerCount())).bytes(in.getBytes());
        }
    }
}

