/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIterableToHeadersWithContainerDeleteMetadataPrefix
implements Binder {
    private final Function<String, String> FN = new Function<String, String>(){

        public String apply(String element) {
            String inLowercase = element.toLowerCase();
            return inLowercase.startsWith("X-Remove-Container-Meta-") ? inLowercase : "X-Remove-Container-Meta-" + inLowercase;
        }

        public String toString() {
            return "prefix: X-Remove-Container-Meta-";
        }
    };

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Iterable), (Object)"this binder is only valid for Iterable!");
        Preconditions.checkNotNull(request, (Object)"request");
        Iterable metadataKeys = Iterables.transform((Iterable)((Iterable)input), this.FN);
        HashMultimap headers = HashMultimap.create();
        for (String metadataKey : metadataKeys) {
            headers.put((Object)metadataKey, (Object)"");
        }
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)headers)).build();
    }
}

