/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import com.amazonaws.services.dynamodbv2.document.Expected;
import com.amazonaws.services.dynamodbv2.document.IncompatibleTypeException;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.internal.Filter;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum InternalUtils {


    public static List<Item> toItemList(List<Map<String, AttributeValue>> items) {
        if (items == null) {
            return Collections.emptyList();
        }
        ArrayList<Item> result = new ArrayList<Item>(items.size());
        for (Map<String, AttributeValue> item : items) {
            result.add(Item.fromMap(InternalUtils.toSimpleMapValue(item)));
        }
        return result;
    }

    public static Map<String, AttributeValue> toAttributeValues(Item item) {
        if (item == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> result = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> entry : item.attributes()) {
            result.put(entry.getKey(), InternalUtils.toAttributeValue(entry.getValue()));
        }
        return result;
    }

    public static Map<String, AttributeValue> fromSimpleMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> result = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey(), InternalUtils.toAttributeValue(entry.getValue()));
        }
        return result;
    }

    public static Map<String, AttributeValueUpdate> toAttributeValueUpdate(List<AttributeUpdate> attributesToUpdate) {
        if (attributesToUpdate == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValueUpdate> result = new LinkedHashMap<String, AttributeValueUpdate>();
        for (AttributeUpdate attribute : attributesToUpdate) {
            AttributeValueUpdate attributeToUpdate = new AttributeValueUpdate().withAction(attribute.getAction());
            if (attribute.getValue() != null) {
                attributeToUpdate.withValue(InternalUtils.toAttributeValue(attribute.getValue()));
            } else if (attribute.getAttributeValues() != null) {
                attributeToUpdate.withValue(InternalUtils.toAttributeValue(attribute.getAttributeValues()));
            }
            result.put(attribute.getAttributeName(), attributeToUpdate);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttributeValue toAttributeValue(Object value) {
        AttributeValue result = new AttributeValue();
        if (value == null) {
            return result.withNULL(Boolean.TRUE);
        }
        if (value instanceof Boolean) {
            return result.withBOOL((Boolean)value);
        }
        if (value instanceof String) {
            return result.withS((String)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return result.withN(bd.toPlainString());
        }
        if (value instanceof Number) {
            return result.withN(value.toString());
        }
        if (value instanceof byte[]) {
            return result.withB(ByteBuffer.wrap((byte[])value));
        }
        if (value instanceof ByteBuffer) {
            return result.withB((ByteBuffer)value);
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            if (set.size() == 0) {
                result.setSS(new LinkedHashSet<String>());
                return result;
            }
            Object element = set.iterator().next();
            if (element instanceof String) {
                Set ss = (Set)value;
                result.setSS(new ArrayList<String>(ss));
                return result;
            } else if (element instanceof Number) {
                Set in = (Set)value;
                ArrayList<String> out = new ArrayList<String>(set.size());
                for (Number n : in) {
                    BigDecimal bd = InternalUtils.toBigDecimal(n);
                    out.add(bd.toPlainString());
                }
                result.setNS(out);
                return result;
            } else if (element instanceof byte[]) {
                Set in = (Set)value;
                ArrayList<ByteBuffer> out = new ArrayList<ByteBuffer>(set.size());
                for (byte[] buf : in) {
                    out.add(ByteBuffer.wrap(buf));
                }
                result.setBS(out);
                return result;
            } else {
                if (!(element instanceof ByteBuffer)) throw new UnsupportedOperationException("element type: " + element.getClass());
                Set bs = (Set)value;
                result.setBS(bs);
            }
            return result;
        } else if (value instanceof List) {
            List in = (List)value;
            ArrayList<AttributeValue> out = new ArrayList<AttributeValue>();
            for (Object v : in) {
                out.add(InternalUtils.toAttributeValue(v));
            }
            result.setL(out);
            return result;
        } else {
            if (!(value instanceof Map)) throw new UnsupportedOperationException("value type: " + value.getClass());
            Map in = (Map)value;
            if (in.size() > 0) {
                for (Map.Entry e : in.entrySet()) {
                    result.addMEntry((String)e.getKey(), InternalUtils.toAttributeValue(e.getValue()));
                }
                return result;
            } else {
                result.setM(new LinkedHashMap<String, AttributeValue>());
            }
        }
        return result;
    }

    public static List<Object> toSimpleList(List<AttributeValue> attrValues) {
        if (attrValues == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(attrValues.size());
        for (AttributeValue attrValue : attrValues) {
            Object value = InternalUtils.toSimpleValue(attrValue);
            result.add(value);
        }
        return result;
    }

    public static <T> List<T> toSimpleListValue(List<AttributeValue> values) {
        if (values == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(values.size());
        for (AttributeValue v : values) {
            T t = InternalUtils.toSimpleValue(v);
            result.add(t);
        }
        return result;
    }

    public static <T> Map<String, T> toSimpleMapValue(Map<String, AttributeValue> values) {
        if (values == null) {
            return null;
        }
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(values.size());
        for (Map.Entry<String, AttributeValue> entry : values.entrySet()) {
            T t = InternalUtils.toSimpleValue(entry.getValue());
            result.put(entry.getKey(), t);
        }
        return result;
    }

    public static String valToString(Object val) {
        if (val instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)val;
            return bd.toPlainString();
        }
        if (val == null) {
            return null;
        }
        if (val instanceof String || val instanceof Boolean || val instanceof Number) {
            return val.toString();
        }
        throw new IncompatibleTypeException("Cannot convert " + val.getClass() + " into a string");
    }

    static <T> T toSimpleValue(AttributeValue value) {
        if (value == null) {
            return null;
        }
        if (Boolean.TRUE.equals(value.getNULL())) {
            return null;
        }
        if (Boolean.FALSE.equals(value.getNULL())) {
            throw new UnsupportedOperationException("False-NULL is not supported in DynamoDB");
        }
        if (value.getBOOL() != null) {
            Boolean t = value.getBOOL();
            return (T)t;
        }
        if (value.getS() != null) {
            String t = value.getS();
            return (T)t;
        }
        if (value.getN() != null) {
            BigDecimal t = new BigDecimal(value.getN());
            return (T)t;
        }
        if (value.getB() != null) {
            byte[] t = BinaryUtils.copyAllBytesFrom((ByteBuffer)value.getB());
            return (T)t;
        }
        if (value.getSS() != null) {
            LinkedHashSet<String> t = new LinkedHashSet<String>(value.getSS());
            return (T)t;
        }
        if (value.getNS() != null) {
            LinkedHashSet<BigDecimal> set = new LinkedHashSet<BigDecimal>(value.getNS().size());
            for (String s : value.getNS()) {
                set.add(new BigDecimal(s));
            }
            LinkedHashSet<BigDecimal> t = set;
            return (T)t;
        }
        if (value.getBS() != null) {
            LinkedHashSet<byte[]> set = new LinkedHashSet<byte[]>(value.getBS().size());
            for (ByteBuffer bb : value.getBS()) {
                set.add(BinaryUtils.copyAllBytesFrom((ByteBuffer)bb));
            }
            LinkedHashSet<byte[]> t = set;
            return (T)t;
        }
        if (value.getL() != null) {
            List<Object> t = InternalUtils.toSimpleList(value.getL());
            return (T)t;
        }
        if (value.getM() != null) {
            Map<String, T> t = InternalUtils.toSimpleMapValue(value.getM());
            return (T)t;
        }
        throw new IllegalArgumentException("Attribute value must not be empty: " + value);
    }

    public static Integer minimum(Integer one, Integer two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        if (one < two) {
            return one;
        }
        return two;
    }

    public static Map<String, ExpectedAttributeValue> toExpectedAttributeValueMap(Collection<Expected> expectedSet) {
        if (expectedSet == null) {
            return null;
        }
        LinkedHashMap<String, ExpectedAttributeValue> expectedMap = new LinkedHashMap<String, ExpectedAttributeValue>();
        for (Expected expected : expectedSet) {
            ComparisonOperator op;
            String attr = expected.getAttribute();
            Object[] values = expected.getValues();
            ExpectedAttributeValue eav = new ExpectedAttributeValue();
            if (values != null) {
                if (values.length > 0) {
                    AttributeValue[] avs = InternalUtils.toAttributeValues(values);
                    eav.withAttributeValueList(avs);
                } else {
                    throw new IllegalStateException("Bug!");
                }
            }
            if ((op = expected.getComparisonOperator()) == null) {
                throw new IllegalArgumentException("Comparison operator for attribute " + expected.getAttribute() + " must be specified");
            }
            eav.withComparisonOperator(op);
            expectedMap.put(attr, eav);
        }
        if (expectedSet.size() != expectedMap.size()) {
            throw new IllegalArgumentException("duplicates attribute names not allowed in input");
        }
        return Collections.unmodifiableMap(expectedMap);
    }

    public static Map<String, Condition> toAttributeConditionMap(Collection<? extends Filter<?>> filters) {
        if (filters == null) {
            return null;
        }
        LinkedHashMap<String, Condition> conditionMap = new LinkedHashMap<String, Condition>();
        for (Filter<?> filter : filters) {
            ComparisonOperator op;
            String attr = filter.getAttribute();
            Object[] values = filter.getValues();
            Condition condition = new Condition();
            if (values != null) {
                if (values.length > 0) {
                    AttributeValue[] avs = InternalUtils.toAttributeValues(values);
                    condition.withAttributeValueList(avs);
                } else {
                    throw new IllegalStateException("Bug!");
                }
            }
            if ((op = filter.getComparisonOperator()) == null) {
                throw new IllegalArgumentException("Comparison operator for attribute " + filter.getAttribute() + " must be specified");
            }
            condition.withComparisonOperator(op);
            conditionMap.put(attr, condition);
        }
        if (filters.size() != conditionMap.size()) {
            throw new IllegalArgumentException("duplicates attribute names not allowed in input");
        }
        return Collections.unmodifiableMap(conditionMap);
    }

    public static AttributeValue[] toAttributeValues(Object[] values) {
        AttributeValue[] attrValues = new AttributeValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            attrValues[i] = InternalUtils.toAttributeValue(values[i]);
        }
        return attrValues;
    }

    public static Map<String, AttributeValue> toAttributeValueMap(Collection<KeyAttribute> primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> keys = new LinkedHashMap<String, AttributeValue>();
        for (KeyAttribute keyAttr : primaryKey) {
            keys.put(keyAttr.getName(), InternalUtils.toAttributeValue(keyAttr.getValue()));
        }
        return Collections.unmodifiableMap(keys);
    }

    public static Map<String, AttributeValue> toAttributeValueMap(PrimaryKey primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        return InternalUtils.toAttributeValueMap(primaryKey.getComponents());
    }

    public static Map<String, AttributeValue> toAttributeValueMap(KeyAttribute ... primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        return InternalUtils.toAttributeValueMap(Arrays.asList(primaryKey));
    }

    public static BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.toString());
    }

    public static Set<BigDecimal> toBigDecimalSet(Number ... val) {
        LinkedHashSet<BigDecimal> set = new LinkedHashSet<BigDecimal>(val.length);
        for (Number n : val) {
            set.add(InternalUtils.toBigDecimal(n));
        }
        return set;
    }

    public static Set<BigDecimal> toBigDecimalSet(Set<Number> vals) {
        LinkedHashSet<BigDecimal> set = new LinkedHashSet<BigDecimal>(vals.size());
        for (Number n : vals) {
            set.add(InternalUtils.toBigDecimal(n));
        }
        return set;
    }

    public static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        String USER_AGENT = "dynamodb-table-api/" + VersionInfoUtils.getVersion();
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    public static void rejectNullValue(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Input value must not be null");
        }
    }

    public static void rejectNullInput(Object input) {
        if (input == null) {
            throw new IllegalArgumentException("Input must not be null");
        }
    }

    public static void rejectEmptyInput(Object[] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException("At least one input must be specified");
        }
    }

    public static void rejectNullOrEmptyInput(Object[] input) {
        InternalUtils.rejectNullInput(input);
        InternalUtils.rejectEmptyInput(input);
    }

    public static void checkInvalidAttrName(String attrName) {
        if (attrName == null || attrName.trim().length() == 0) {
            throw new IllegalArgumentException("Attribute name must not be null or empty");
        }
    }

    public static void checkInvalidAttribute(String attrName, Object val) {
        InternalUtils.checkInvalidAttrName(attrName);
        InternalUtils.rejectNullValue(val);
    }
}

