/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.handlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.openstack.swift.v1.CopyObjectException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;

public class CloudFilesErrorHandler
implements HttpErrorHandler {
    public static final String PREFIX = "^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/";
    public static final Pattern CONTAINER_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)$");
    public static final Pattern CONTAINER_KEY_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)/(.*)");

    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        String message = data != null ? new String(data) : null;
        Object exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        switch (response.getStatusCode()) {
            case 401: {
                exception = new AuthorizationException(((Throwable)exception).getMessage(), (Throwable)exception);
                break;
            }
            case 404: {
                HttpResponseException oldException = exception;
                String sourcePath = command.getCurrentRequest().getFirstHeaderOrNull("X-Copy-From");
                if (sourcePath != null) {
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    int startOfDestinationPath = path.lastIndexOf("/", path.lastIndexOf("/") - 1);
                    String destinationPath = path.substring(startOfDestinationPath);
                    exception = new CopyObjectException(sourcePath, destinationPath, message);
                    ((Throwable)exception).initCause((Throwable)oldException);
                    break;
                }
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                String path = command.getCurrentRequest().getEndpoint().getPath();
                Matcher matcher = CONTAINER_PATH.matcher(path);
                if (matcher.find()) {
                    exception = new ContainerNotFoundException(matcher.group(1), message);
                    ((Throwable)exception).initCause((Throwable)oldException);
                    break;
                }
                matcher = CONTAINER_KEY_PATH.matcher(path);
                if (!matcher.find()) break;
                exception = new KeyNotFoundException(matcher.group(1), matcher.group(2), message);
                ((Throwable)exception).initCause((Throwable)oldException);
                break;
            }
            case 409: {
                exception = new IllegalStateException(((Throwable)exception).getMessage(), (Throwable)exception);
                break;
            }
            case 413: {
                exception = new InsufficientResourcesException(((Throwable)exception).getMessage(), (Throwable)exception);
            }
        }
        command.setException((Exception)exception);
    }
}

