/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.xml.IpPermissionHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SecurityGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<SecurityGroup> {
    protected final IpPermissionHandler ipPermissionHandler;
    protected final Supplier<String> defaultRegion;
    protected StringBuilder currentText = new StringBuilder();
    protected SecurityGroup.Builder<?> builder;
    protected boolean inIpPermissions;
    protected int itemDepth;
    protected String region;

    @Inject
    public SecurityGroupHandler(IpPermissionHandler ipPermissionHandler, @Region Supplier<String> defaultRegion) {
        this.ipPermissionHandler = ipPermissionHandler;
        this.defaultRegion = defaultRegion;
    }

    protected SecurityGroup.Builder<?> builder() {
        return SecurityGroup.builder().region(this.region);
    }

    public ParseSax.HandlerForGeneratedRequestWithResult<SecurityGroup> setContext(HttpRequest request) {
        this.region = AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)));
        if (this.region == null) {
            this.region = (String)this.defaultRegion.get();
        }
        this.builder = this.builder();
        return super.setContext(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityGroup getResult() {
        try {
            SecurityGroup securityGroup = this.builder.build();
            return securityGroup;
        }
        finally {
            this.builder = this.builder();
        }
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            ++this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipPermissions")) {
            this.inIpPermissions = true;
        }
        if (this.inIpPermissions) {
            this.ipPermissionHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            this.endItem(uri, name, qName);
            --this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipPermissions")) {
            this.inIpPermissions = false;
            this.itemDepth = 0;
        } else if (this.inIpPermissions) {
            this.ipPermissionHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupName")) {
            this.builder.name(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupId")) {
            this.builder.id(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ownerId")) {
            this.builder.ownerId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupDescription")) {
            this.builder.description(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    protected void endItem(String uri, String name, String qName) throws SAXException {
        if (this.inIpPermissions) {
            if (this.itemDepth == 2) {
                this.builder.ipPermission(this.ipPermissionHandler.getResult());
            } else {
                this.ipPermissionHandler.endElement(uri, name, qName);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inIpPermissions) {
            this.ipPermissionHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

