/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.enterprisechef.domain;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.security.PublicKey;

public class User {
    private final String username;
    @SerializedName(value="first_name")
    private final String firstName;
    @SerializedName(value="middle_name")
    private final String middleName;
    @SerializedName(value="last_name")
    private final String lastName;
    @SerializedName(value="display_name")
    private final String displayName;
    private final String email;
    @SerializedName(value="public_key")
    private final PublicKey publicKey;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"username", "first_name", "middle_name", "last_name", "display_name", "email", "public_key"})
    protected User(String username, String firstName, String middleName, String lastName, String displayName, String email, PublicKey publicKey) {
        this.username = username;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.displayName = displayName;
        this.email = email;
        this.publicKey = publicKey;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.middleName == null ? 0 : this.middleName.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.middleName == null ? other.middleName != null : !this.middleName.equals(other.middleName)) {
            return false;
        }
        if (this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "User [username=" + this.username + ", firstName=" + this.firstName + ", middleName=" + this.middleName + ", lastName=" + this.lastName + ", displayName=" + this.displayName + ", email=" + this.email + ", publicKey=" + this.publicKey + "]";
    }

    public static class Builder {
        private String username;
        private String firstName;
        private String middleName;
        private String lastName;
        private String displayName;
        private String email;
        private PublicKey publicKey;

        public Builder username(String username) {
            this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = (String)Preconditions.checkNotNull((Object)firstName, (Object)"firstName");
            return this;
        }

        public Builder middleName(String middleName) {
            this.middleName = (String)Preconditions.checkNotNull((Object)middleName, (Object)"middleName");
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = (String)Preconditions.checkNotNull((Object)lastName, (Object)"lastName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = (String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
            return this;
        }

        public Builder email(String email) {
            this.email = (String)Preconditions.checkNotNull((Object)email, (Object)"email");
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.publicKey = (PublicKey)Preconditions.checkNotNull((Object)publicKey, (Object)"publicKey");
            return this;
        }

        public User build() {
            return new User(this.username, this.firstName, this.middleName, this.lastName, this.displayName, this.email, this.publicKey);
        }
    }
}

