/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.softlayer.compute.functions.VirtualGuestToHardware;
import org.jclouds.softlayer.compute.functions.VirtualGuestToImage;
import org.jclouds.softlayer.domain.TagReference;
import org.jclouds.softlayer.domain.VirtualGuest;

@Singleton
public class VirtualGuestToNodeMetadata
implements Function<VirtualGuest, NodeMetadata> {
    public static final Map<VirtualGuest.State, NodeMetadata.Status> serverStateToNodeStatus = ImmutableMap.builder().put((Object)VirtualGuest.State.HALTED, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualGuest.State.PAUSED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VirtualGuest.State.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)VirtualGuest.State.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private final Supplier<Set<? extends Location>> locations;
    private final GroupNamingConvention nodeNamingConvention;
    private final VirtualGuestToImage virtualGuestToImage;
    private final VirtualGuestToHardware virtualGuestToHardware;

    @Inject
    VirtualGuestToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, GroupNamingConvention.Factory namingConvention, VirtualGuestToImage virtualGuestToImage, VirtualGuestToHardware virtualGuestToHardware) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.virtualGuestToImage = (VirtualGuestToImage)Preconditions.checkNotNull((Object)virtualGuestToImage, (Object)"virtualGuestToImage");
        this.virtualGuestToHardware = (VirtualGuestToHardware)Preconditions.checkNotNull((Object)virtualGuestToHardware, (Object)"virtualGuestToHardware");
    }

    public NodeMetadata apply(VirtualGuest from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getHostname());
        builder.hostname(from.getFullyQualifiedDomainName());
        if (from.getDatacenter() != null) {
            builder.location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)from.getDatacenter().getName())).orNull());
        }
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getHostname()));
        builder.hardware(this.virtualGuestToHardware.apply(from));
        Image image = this.virtualGuestToImage.apply(from);
        if (image != null) {
            builder.imageId(image.getId());
            builder.operatingSystem(image.getOperatingSystem());
        }
        if (from.getPowerState() != null) {
            builder.status(serverStateToNodeStatus.get((Object)from.getPowerState().getKeyName()));
        }
        if (from.getPrimaryIpAddress() != null) {
            builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.getPrimaryIpAddress()));
        }
        if (from.getPrimaryBackendIpAddress() != null) {
            builder.privateAddresses((Iterable)ImmutableSet.of((Object)from.getPrimaryBackendIpAddress()));
        }
        if (from.getTagReferences() != null && !from.getTagReferences().isEmpty()) {
            ArrayList tags = Lists.newArrayList();
            for (TagReference tagReference : from.getTagReferences()) {
                if (tagReference == null) continue;
                tags.add(tagReference.getTag().getName());
            }
            builder.tags((Iterable)tags);
        }
        return builder.build();
    }
}

