/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import org.jclouds.collect.AdvanceUntilEmptyIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.features.MessageApi;
import org.jclouds.sqs.options.ReceiveMessageOptions;

@Beta
public class SQS {
    public static FluentIterable<Message> receiveAllAtRate(MessageApi api, int messagesPerPage, ReceiveMessageOptions options) {
        return AdvanceUntilEmptyIterable.create((Supplier)new MoreMessages(api, messagesPerPage, options)).concat();
    }

    private static class MoreMessages
    implements Supplier<FluentIterable<Message>> {
        private static final ReceiveMessageOptions NO_OPTIONS = new ReceiveMessageOptions();
        private MessageApi api;
        private int max;
        private ReceiveMessageOptions options;

        private MoreMessages(MessageApi api, int max, @Nullable ReceiveMessageOptions options) {
            this.api = (MessageApi)Preconditions.checkNotNull((Object)api, (Object)"message api");
            Preconditions.checkArgument((max > 0 ? 1 : 0) != 0, (Object)"max messages per request must be a positive number");
            this.max = max;
            this.options = (ReceiveMessageOptions)Objects.firstNonNull((Object)options, (Object)NO_OPTIONS);
        }

        public FluentIterable<Message> get() {
            return this.api.receive(this.max, this.options);
        }
    }
}

