/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DirectionalPoolRecordDetailHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<DirectionalPoolRecordDetail> {
    private DirectionalPoolRecordDetail.Builder drd = DirectionalPoolRecordDetail.builder();
    private DirectionalPoolRecord.Builder dr = DirectionalPoolRecord.drBuilder();
    private String zoneName;
    private String dname;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectionalPoolRecordDetail getResult() {
        try {
            DirectionalPoolRecordDetail directionalPoolRecordDetail = this.drd.record(this.dr.build()).build();
            return directionalPoolRecordDetail;
        }
        finally {
            this.drd = DirectionalPoolRecordDetail.builder().zoneName(this.zoneName).name(this.dname);
            this.dr = DirectionalPoolRecord.drBuilder();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (attributes.containsKey("ZoneName")) {
            this.zoneName = (String)attributes.get("ZoneName");
            this.dname = (String)attributes.get("DName");
            this.drd.zoneName(this.zoneName).name(this.dname);
        }
        if (attributes.containsKey("DirPoolRecordId")) {
            this.drd.id((String)attributes.get("DirPoolRecordId"));
        }
        if (attributes.containsKey("GroupId")) {
            this.drd.group(IdAndName.create((String)attributes.get("GroupId"), (String)attributes.get("GroupName")));
        }
        if (attributes.containsKey("GeolocationGroupId")) {
            this.drd.geolocationGroup(IdAndName.create((String)attributes.get("GeolocationGroupId"), (String)attributes.get("GeolocationGroupName")));
        }
        if (attributes.containsKey("SourceIPGroupId")) {
            this.drd.sourceIpGroup(IdAndName.create((String)attributes.get("SourceIPGroupId"), (String)attributes.get("SourceIPGroupName")));
        }
        if (attributes.containsKey("recordType")) {
            this.dr.type((String)attributes.get("recordType"));
            this.dr.ttl(Integer.parseInt((String)attributes.get("TTL")));
            this.dr.noResponseRecord("true".equalsIgnoreCase((String)attributes.get("noResponseRecord")));
        }
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"InfoValues")) {
            this.dr.rdata(attributes.values());
        }
    }
}

