/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.converters;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.nnsoft.guice.rocoto.converters.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesConverter
extends AbstractConverter<Properties> {
    private static final String PROPERTIES_ENCODING = "ISO-8859-1";

    public Object convert(String value, TypeLiteral<?> toType) {
        Properties properties = new Properties();
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(value.getBytes(PROPERTIES_ENCODING));
            properties.load(bais);
        }
        catch (IOException e) {
            throw new ProvisionException("Failed to parse " + value + "' into Properties", (Throwable)e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }
}

