/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeInternetGatewaysRequestMarshaller
implements Marshaller<Request<DescribeInternetGatewaysRequest>, DescribeInternetGatewaysRequest> {
    public Request<DescribeInternetGatewaysRequest> marshall(DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        if (describeInternetGatewaysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInternetGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInternetGateways");
        request.addParameter("Version", "2015-03-01");
        List<String> internetGatewayIdsList = describeInternetGatewaysRequest.getInternetGatewayIds();
        int internetGatewayIdsListIndex = 1;
        for (String internetGatewayIdsListValue : internetGatewayIdsList) {
            if (internetGatewayIdsListValue != null) {
                request.addParameter("InternetGatewayId." + internetGatewayIdsListIndex, StringUtils.fromString((String)internetGatewayIdsListValue));
            }
            ++internetGatewayIdsListIndex;
        }
        List<Filter> filtersList = describeInternetGatewaysRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

