/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class Project
implements Comparable<Project> {
    private final String id;
    private final String account;
    private final String displayText;
    private final String domain;
    private final String domainId;
    private final String name;
    private final State state;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromDomain(this);
    }

    @ConstructorProperties(value={"id", "account", "displaytext", "domain", "domainid", "name", "state", "tags"})
    protected Project(String id, String account, String displayText, String domain, String domainId, String name, State state, @Nullable Set<Tag> tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.account = account;
        this.displayText = displayText;
        this.domain = domain;
        this.domainId = domainId;
        this.name = name;
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.displayText, this.domain, this.domainId, this.name, this.state, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Project that = (Project)Project.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.displayText, (Object)that.displayText) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal(this.tags, that.tags);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("account", (Object)this.account).add("displayText", (Object)this.displayText).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("name", (Object)this.name).add("state", (Object)this.state).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Project other) {
        return this.id.compareTo(other.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected String displayText;
        protected String domain;
        protected String domainId;
        protected String name;
        protected State state;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public Project build() {
            return new Project(this.id, this.account, this.displayText, this.domain, this.domainId, this.name, this.state, this.tags);
        }

        public T fromDomain(Project in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).displayText(in.getDisplayText())).domain(in.getDomain())).domainId(in.getDomainId())).name(in.getName())).state(in.getState())).tags(in.getTags());
        }
    }

    public static enum State {
        ACTIVE,
        DISABLED,
        SUSPENDED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

