/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.ContentMetadata;
import org.jclouds.rest.Binder;

@Singleton
public class BindAzureContentMetadataToRequest
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String contentDisposition;
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof ContentMetadata), (Object)"this binder is only valid for ContentMetadata");
        Preconditions.checkNotNull(request, (Object)"request");
        ContentMetadata contentMetadata = (ContentMetadata)input;
        ImmutableMap.Builder headers = ImmutableMap.builder();
        String contentType = contentMetadata.getContentType();
        if (contentType != null) {
            headers.put((Object)"x-ms-blob-type", (Object)contentType);
        }
        if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
            headers.put((Object)"x-ms-blob-content-disposition", (Object)contentDisposition);
        }
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)Multimaps.forMap((Map)headers.build()))).build();
    }
}

