/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.config;

import com.google.common.base.Supplier;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.net.URI;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.services.HPExtensionCDN;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.config.SwiftHttpApiModule;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Suppliers2;

@ConfiguresHttpApi
public class HPCloudObjectStorageHttpApiModule
extends SwiftHttpApiModule<HPCloudObjectStorageApi> {
    public HPCloudObjectStorageHttpApiModule() {
        super(HPCloudObjectStorageApi.class);
    }

    protected void bindResolvedClientsToCommonSwift() {
        this.bind(CommonSwiftClient.class).to(HPCloudObjectStorageApi.class).in(Scopes.SINGLETON);
    }

    private static Supplier<URI> getUriSupplier(String serviceType, String apiVersion, RegionIdToURISupplier.Factory factory, String region) {
        RegionIdToURISupplier endpointsSupplier = factory.createForApiTypeAndVersion(serviceType, apiVersion);
        if (region.isEmpty()) {
            return Suppliers2.getLastValueInMap((Supplier)endpointsSupplier);
        }
        return Suppliers2.getValueInMapOrNull((Supplier)endpointsSupplier, (Object)region);
    }

    @Provides
    @Singleton
    @HPExtensionCDN
    @Nullable
    protected Supplier<URI> provideCDNUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion, @Named(value="jclouds.region") String region) {
        return HPCloudObjectStorageHttpApiModule.getUriSupplier("hpext:cdn", apiVersion, factory, region);
    }

    public static class HPCloudObjectStorageEndpointModule
    extends KeystoneAuthenticationModule {
        @Provides
        @Singleton
        @Storage
        @Nullable
        protected Supplier<URI> provideStorageUrl(RegionIdToURISupplier.Factory factory, @ApiVersion String apiVersion, @Named(value="jclouds.region") String region) {
            return HPCloudObjectStorageHttpApiModule.getUriSupplier("object-store", null, factory, region);
        }
    }
}

