/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.event;

import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.joda.time.DateTime;

public class S3EventNotification {
    private final List<S3EventNotificationRecord> records;

    @JsonCreator
    public S3EventNotification(@JsonProperty(value="Records") List<S3EventNotificationRecord> records) {
        this.records = records;
    }

    public static S3EventNotification parseJson(String json) {
        return (S3EventNotification)Jackson.fromJsonString((String)json, S3EventNotification.class);
    }

    public List<S3EventNotificationRecord> getRecords() {
        return this.records;
    }

    public static class S3EventNotificationRecord {
        private final String awsRegion;
        private final String eventName;
        private final String eventSource;
        private DateTime eventTime = null;
        private final String eventVersion;
        private final RequestParametersEntity requestParameters;
        private final ResponseElementsEntity responseElements;
        private final S3Entity s3;
        private final UserIdentityEntity userIdentity;

        @JsonCreator
        public S3EventNotificationRecord(@JsonProperty(value="awsRegion") String awsRegion, @JsonProperty(value="eventName") String eventName, @JsonProperty(value="eventSource") String eventSource, @JsonProperty(value="eventTime") String eventTime, @JsonProperty(value="eventVersion") String eventVersion, @JsonProperty(value="requestParameters") RequestParametersEntity requestParameters, @JsonProperty(value="responseElements") ResponseElementsEntity responseElements, @JsonProperty(value="s3") S3Entity s3, @JsonProperty(value="userIdentity") UserIdentityEntity userIdentity) {
            this.awsRegion = awsRegion;
            this.eventName = eventName;
            this.eventSource = eventSource;
            if (eventTime != null) {
                this.eventTime = DateTime.parse((String)eventTime);
            }
            this.eventVersion = eventVersion;
            this.requestParameters = requestParameters;
            this.responseElements = responseElements;
            this.s3 = s3;
            this.userIdentity = userIdentity;
        }

        public String getAwsRegion() {
            return this.awsRegion;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getEventSource() {
            return this.eventSource;
        }

        public DateTime getEventTime() {
            return this.eventTime;
        }

        public String getEventVersion() {
            return this.eventVersion;
        }

        public RequestParametersEntity getRequestParameters() {
            return this.requestParameters;
        }

        public ResponseElementsEntity getResponseElements() {
            return this.responseElements;
        }

        public S3Entity getS3() {
            return this.s3;
        }

        public UserIdentityEntity getUserIdentity() {
            return this.userIdentity;
        }
    }

    public static class ResponseElementsEntity {
        private final String xAmzId2;
        private final String xAmzRequestId;

        @JsonCreator
        public ResponseElementsEntity(@JsonProperty(value="x-amz-id-2") String xAmzId2, @JsonProperty(value="x-amz-request-id") String xAmzRequestId) {
            this.xAmzId2 = xAmzId2;
            this.xAmzRequestId = xAmzRequestId;
        }

        public String getxAmzId2() {
            return this.xAmzId2;
        }

        public String getxAmzRequestId() {
            return this.xAmzRequestId;
        }
    }

    public static class RequestParametersEntity {
        private final String sourceIPAddress;

        @JsonCreator
        public RequestParametersEntity(@JsonProperty(value="sourceIPAddress") String sourceIPAddress) {
            this.sourceIPAddress = sourceIPAddress;
        }

        public String getSourceIPAddress() {
            return this.sourceIPAddress;
        }
    }

    public static class S3Entity {
        private final String configurationId;
        private final S3BucketEntity bucket;
        private final S3ObjectEntity object;
        private final String s3SchemaVersion;

        @JsonCreator
        public S3Entity(@JsonProperty(value="configurationId") String configurationId, @JsonProperty(value="bucket") S3BucketEntity bucket, @JsonProperty(value="object") S3ObjectEntity object, @JsonProperty(value="s3SchemaVersion") String s3SchemaVersion) {
            this.configurationId = configurationId;
            this.bucket = bucket;
            this.object = object;
            this.s3SchemaVersion = s3SchemaVersion;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }

        public S3BucketEntity getBucket() {
            return this.bucket;
        }

        public S3ObjectEntity getObject() {
            return this.object;
        }

        public String getS3SchemaVersion() {
            return this.s3SchemaVersion;
        }
    }

    public static class S3ObjectEntity {
        private final String key;
        private final Long size;
        private final String eTag;
        private final String versionId;

        @Deprecated
        public S3ObjectEntity(String key, Integer size, String eTag, String versionId) {
            this.key = key;
            this.size = size == null ? null : Long.valueOf(size.longValue());
            this.eTag = eTag;
            this.versionId = versionId;
        }

        @JsonCreator
        public S3ObjectEntity(@JsonProperty(value="key") String key, @JsonProperty(value="size") Long size, @JsonProperty(value="eTag") String eTag, @JsonProperty(value="versionId") String versionId) {
            this.key = key;
            this.size = size;
            this.eTag = eTag;
            this.versionId = versionId;
        }

        public String getKey() {
            return this.key;
        }

        @Deprecated
        public Integer getSize() {
            return this.size == null ? null : Integer.valueOf(this.size.intValue());
        }

        @JsonProperty(value="size")
        public Long getSizeAsLong() {
            return this.size;
        }

        public String geteTag() {
            return this.eTag;
        }

        public String getVersionId() {
            return this.versionId;
        }
    }

    public static class S3BucketEntity {
        private final String name;
        private final UserIdentityEntity ownerIdentity;
        private final String arn;

        @JsonCreator
        public S3BucketEntity(@JsonProperty(value="name") String name, @JsonProperty(value="ownerIdentity") UserIdentityEntity ownerIdentity, @JsonProperty(value="arn") String arn) {
            this.name = name;
            this.ownerIdentity = ownerIdentity;
            this.arn = arn;
        }

        public String getName() {
            return this.name;
        }

        public UserIdentityEntity getOwnerIdentity() {
            return this.ownerIdentity;
        }

        public String getArn() {
            return this.arn;
        }
    }

    public static class UserIdentityEntity {
        private final String principalId;

        @JsonCreator
        public UserIdentityEntity(@JsonProperty(value="principalId") String principalId) {
            this.principalId = principalId;
        }

        public String getPrincipalId() {
            return this.principalId;
        }
    }
}

