/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAssociationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<AssociationFilter> associationFilterList;
    private Integer maxResults;
    private String nextToken;

    public List<AssociationFilter> getAssociationFilterList() {
        if (this.associationFilterList == null) {
            this.associationFilterList = new ListWithAutoConstructFlag();
            this.associationFilterList.setAutoConstruct(true);
        }
        return this.associationFilterList;
    }

    public void setAssociationFilterList(Collection<AssociationFilter> associationFilterList) {
        if (associationFilterList == null) {
            this.associationFilterList = null;
            return;
        }
        ListWithAutoConstructFlag associationFilterListCopy = new ListWithAutoConstructFlag(associationFilterList.size());
        associationFilterListCopy.addAll(associationFilterList);
        this.associationFilterList = associationFilterListCopy;
    }

    public ListAssociationsRequest withAssociationFilterList(AssociationFilter ... associationFilterList) {
        if (this.getAssociationFilterList() == null) {
            this.setAssociationFilterList(new ArrayList<AssociationFilter>(associationFilterList.length));
        }
        for (AssociationFilter value : associationFilterList) {
            this.getAssociationFilterList().add(value);
        }
        return this;
    }

    public ListAssociationsRequest withAssociationFilterList(Collection<AssociationFilter> associationFilterList) {
        if (associationFilterList == null) {
            this.associationFilterList = null;
        } else {
            ListWithAutoConstructFlag associationFilterListCopy = new ListWithAutoConstructFlag(associationFilterList.size());
            associationFilterListCopy.addAll(associationFilterList);
            this.associationFilterList = associationFilterListCopy;
        }
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public ListAssociationsRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListAssociationsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociationFilterList() != null) {
            sb.append("AssociationFilterList: " + this.getAssociationFilterList() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociationFilterList() == null ? 0 : this.getAssociationFilterList().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsRequest)) {
            return false;
        }
        ListAssociationsRequest other = (ListAssociationsRequest)obj;
        if (other.getAssociationFilterList() == null ^ this.getAssociationFilterList() == null) {
            return false;
        }
        if (other.getAssociationFilterList() != null && !other.getAssociationFilterList().equals(this.getAssociationFilterList())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListAssociationsRequest clone() {
        return (ListAssociationsRequest)super.clone();
    }
}

