/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={AuthenticateRequest.class})
public interface VirtualIPApi {
    @Named(value="virtualip:create")
    @POST
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/virtualips")
    public VirtualIPWithId create(@BinderParam(value=BindToJsonPayload.class) VirtualIP var1);

    @Named(value="virtualip:list")
    @GET
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @SelectJson(value={"virtualIps"})
    @Path(value="/virtualips")
    public Iterable<VirtualIPWithId> list();

    @Named(value="virtualip:delete")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/virtualips/{id}")
    @Consumes(value={"*/*"})
    public boolean delete(@PathParam(value="id") int var1);

    @Named(value="virtualip:delete")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/virtualips")
    @Consumes(value={"*/*"})
    public boolean delete(@QueryParam(value="id") Iterable<Integer> var1);
}

