/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Atomics;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;

public class SecurityGroupRuleToIpPermission
implements Function<SecurityGroupRule, IpPermission> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Predicate<AtomicReference<RegionAndName>> returnSecurityGroupExistsInRegion;
    protected final Supplier<Map<String, Location>> locationIndex;
    LoadingCache<RegionAndName, SecurityGroupInRegion> groupMap;

    @Inject
    public SecurityGroupRuleToIpPermission(@Named(value="SECURITYGROUP_PRESENT") Predicate<AtomicReference<RegionAndName>> returnSecurityGroupExistsInRegion, Supplier<Map<String, Location>> locationIndex, LoadingCache<RegionAndName, SecurityGroupInRegion> groupMap) {
        this.returnSecurityGroupExistsInRegion = (Predicate)Preconditions.checkNotNull(returnSecurityGroupExistsInRegion, (Object)"returnSecurityGroupExistsInRegion");
        this.locationIndex = (Supplier)Preconditions.checkNotNull(locationIndex, (Object)"locationIndex");
        this.groupMap = (LoadingCache)Preconditions.checkNotNull(groupMap, (Object)"groupMap");
    }

    public IpPermission apply(SecurityGroupRule rule) {
        String region;
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(rule.getIpProtocol());
        builder.fromPort(rule.getFromPort());
        builder.toPort(rule.getToPort());
        if (rule.getGroup() != null && (region = (String)Iterables.getFirst((Iterable)Iterables.filter(((Map)this.locationIndex.get()).keySet(), this.isSecurityGroupInRegion(rule.getGroup().getName())), null)) != null) {
            SecurityGroupInRegion group = (SecurityGroupInRegion)this.groupMap.getUnchecked((Object)RegionAndName.fromRegionAndName(region, rule.getGroup().getName()));
            builder.groupId(region + "/" + group.getSecurityGroup().getId());
        }
        if (rule.getIpRange() != null) {
            builder.cidrBlock(rule.getIpRange());
        }
        return builder.build();
    }

    protected Predicate<String> isSecurityGroupInRegion(final String groupName) {
        return new Predicate<String>(){

            public boolean apply(String region) {
                AtomicReference securityGroupInRegionRef = Atomics.newReference((Object)RegionAndName.fromRegionAndName(region, groupName));
                return SecurityGroupRuleToIpPermission.this.returnSecurityGroupExistsInRegion.apply((Object)securityGroupInRegionRef);
            }
        };
    }
}

