/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.v2_0.domain.Access;

@Singleton
public class RetryOnRenew
implements HttpRetryHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    @VisibleForTesting
    static final int NUM_RETRIES = 5;
    private final LoadingCache<Credentials, Access> authenticationResponseCache;
    private final BackoffLimitedRetryHandler backoffHandler;
    private static final Cache<HttpCommand, Integer> retryCountMap = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    @Inject
    protected RetryOnRenew(LoadingCache<Credentials, Access> authenticationResponseCache, BackoffLimitedRetryHandler backoffHandler) {
        this.authenticationResponseCache = authenticationResponseCache;
        this.backoffHandler = backoffHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        boolean retry = false;
        try {
            switch (response.getStatusCode()) {
                case 401: {
                    Multimap headers = command.getCurrentRequest().getHeaders();
                    if (headers != null && headers.containsKey((Object)"X-Auth-User") && headers.containsKey((Object)"X-Auth-Key") && !headers.containsKey((Object)"X-Auth-Token")) {
                        retry = false;
                        break;
                    }
                    HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
                    Integer count = (Integer)retryCountMap.getIfPresent((Object)command);
                    if (count == null) {
                        this.logger.debug("invalidating authentication token - first time for %s", new Object[]{command});
                        retryCountMap.put((Object)command, (Object)1);
                        this.authenticationResponseCache.invalidateAll();
                        retry = true;
                        break;
                    }
                    if (count + 1 >= 5) {
                        this.logger.debug("too many 401s - giving up after: %s for %s", new Object[]{count, command});
                        retry = false;
                        break;
                    }
                    this.logger.debug("invalidating authentication token - retry %s for %s", new Object[]{count, command});
                    retryCountMap.put((Object)command, (Object)(count + 1));
                    this.authenticationResponseCache.invalidateAll();
                    Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
                    retry = true;
                    break;
                }
                case 408: {
                    boolean bl = this.backoffHandler.shouldRetryRequest(command, response);
                    return bl;
                }
            }
            boolean bl = retry;
            return bl;
        }
        finally {
            HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
        }
    }
}

