/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.DeleteIdentityRequest;
import com.amazonaws.services.simpleemail.model.DeleteIdentityResult;
import com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesResult;
import com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesResult;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesResult;
import com.amazonaws.services.simpleemail.model.GetSendQuotaRequest;
import com.amazonaws.services.simpleemail.model.GetSendQuotaResult;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsResult;
import com.amazonaws.services.simpleemail.model.ListIdentitiesRequest;
import com.amazonaws.services.simpleemail.model.ListIdentitiesResult;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesResult;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledResult;
import com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledResult;
import com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicResult;
import com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest;
import com.amazonaws.services.simpleemail.model.VerifyDomainDkimResult;
import com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest;
import com.amazonaws.services.simpleemail.model.VerifyDomainIdentityResult;
import com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest;
import com.amazonaws.services.simpleemail.model.VerifyEmailIdentityResult;
import com.amazonaws.services.simpleemail.model.transform.DeleteIdentityRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.DeleteIdentityResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.DeleteVerifiedEmailAddressRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityDkimAttributesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityDkimAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityNotificationAttributesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityNotificationAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityVerificationAttributesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityVerificationAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendQuotaRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendQuotaResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListIdentitiesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListIdentitiesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.MessageRejectedExceptionUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendEmailRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendEmailResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendRawEmailRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendRawEmailResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityDkimEnabledRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityDkimEnabledResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityFeedbackForwardingEnabledRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityFeedbackForwardingEnabledResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityNotificationTopicRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityNotificationTopicResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainDkimRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainDkimResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainIdentityRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainIdentityResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyEmailAddressRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyEmailIdentityRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyEmailIdentityResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class AmazonSimpleEmailServiceClient
extends AmazonWebServiceClient
implements AmazonSimpleEmailService {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonSimpleEmailServiceClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new MessageRejectedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller());
        this.setEndpoint("email.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpleemail/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simpleemail/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentityResult deleteIdentity(DeleteIdentityRequest deleteIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIdentityRequest> request = null;
        Response<DeleteIdentityResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIdentityRequestMarshaller().marshall((DeleteIdentityRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIdentityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new DeleteIdentityResultStaxUnmarshaller(), executionContext);
            DeleteIdentityResult deleteIdentityResult = (DeleteIdentityResult)response.getAwsResponse();
            return deleteIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVerifiedEmailAddressesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVerifiedEmailAddressesRequest> request = null;
        Response<ListVerifiedEmailAddressesResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVerifiedEmailAddressesRequestMarshaller().marshall((ListVerifiedEmailAddressesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVerifiedEmailAddressesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListVerifiedEmailAddressesResultStaxUnmarshaller(), executionContext);
            ListVerifiedEmailAddressesResult listVerifiedEmailAddressesResult = (ListVerifiedEmailAddressesResult)response.getAwsResponse();
            return listVerifiedEmailAddressesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSendStatisticsResult getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSendStatisticsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSendStatisticsRequest> request = null;
        Response<GetSendStatisticsResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSendStatisticsRequestMarshaller().marshall((GetSendStatisticsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSendStatisticsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetSendStatisticsResultStaxUnmarshaller(), executionContext);
            GetSendStatisticsResult getSendStatisticsResult = (GetSendStatisticsResult)response.getAwsResponse();
            return getSendStatisticsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyEmailIdentityResult verifyEmailIdentity(VerifyEmailIdentityRequest verifyEmailIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyEmailIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyEmailIdentityRequest> request = null;
        Response<VerifyEmailIdentityResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyEmailIdentityRequestMarshaller().marshall((VerifyEmailIdentityRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyEmailIdentityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new VerifyEmailIdentityResultStaxUnmarshaller(), executionContext);
            VerifyEmailIdentityResult verifyEmailIdentityResult = (VerifyEmailIdentityResult)response.getAwsResponse();
            return verifyEmailIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityNotificationAttributesResult getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityNotificationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdentityNotificationAttributesRequest> request = null;
        Response<GetIdentityNotificationAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdentityNotificationAttributesRequestMarshaller().marshall((GetIdentityNotificationAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIdentityNotificationAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetIdentityNotificationAttributesResultStaxUnmarshaller(), executionContext);
            GetIdentityNotificationAttributesResult getIdentityNotificationAttributesResult = (GetIdentityNotificationAttributesResult)response.getAwsResponse();
            return getIdentityNotificationAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyDomainDkimResult verifyDomainDkim(VerifyDomainDkimRequest verifyDomainDkimRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyDomainDkimRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyDomainDkimRequest> request = null;
        Response<VerifyDomainDkimResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyDomainDkimRequestMarshaller().marshall((VerifyDomainDkimRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyDomainDkimRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new VerifyDomainDkimResultStaxUnmarshaller(), executionContext);
            VerifyDomainDkimResult verifyDomainDkimResult = (VerifyDomainDkimResult)response.getAwsResponse();
            return verifyDomainDkimResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityDkimAttributesResult getIdentityDkimAttributes(GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityDkimAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdentityDkimAttributesRequest> request = null;
        Response<GetIdentityDkimAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdentityDkimAttributesRequestMarshaller().marshall((GetIdentityDkimAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIdentityDkimAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetIdentityDkimAttributesResultStaxUnmarshaller(), executionContext);
            GetIdentityDkimAttributesResult getIdentityDkimAttributesResult = (GetIdentityDkimAttributesResult)response.getAwsResponse();
            return getIdentityDkimAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyEmailAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<VerifyEmailAddressRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyEmailAddressRequestMarshaller().marshall((VerifyEmailAddressRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyEmailAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendRawEmailResult sendRawEmail(SendRawEmailRequest sendRawEmailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendRawEmailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendRawEmailRequest> request = null;
        Response<SendRawEmailResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendRawEmailRequestMarshaller().marshall((SendRawEmailRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendRawEmailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new SendRawEmailResultStaxUnmarshaller(), executionContext);
            SendRawEmailResult sendRawEmailResult = (SendRawEmailResult)response.getAwsResponse();
            return sendRawEmailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentitiesResult listIdentities(ListIdentitiesRequest listIdentitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentitiesRequest> request = null;
        Response<ListIdentitiesResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentitiesRequestMarshaller().marshall((ListIdentitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIdentitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListIdentitiesResultStaxUnmarshaller(), executionContext);
            ListIdentitiesResult listIdentitiesResult = (ListIdentitiesResult)response.getAwsResponse();
            return listIdentitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityVerificationAttributesResult getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityVerificationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdentityVerificationAttributesRequest> request = null;
        Response<GetIdentityVerificationAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdentityVerificationAttributesRequestMarshaller().marshall((GetIdentityVerificationAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIdentityVerificationAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetIdentityVerificationAttributesResultStaxUnmarshaller(), executionContext);
            GetIdentityVerificationAttributesResult getIdentityVerificationAttributesResult = (GetIdentityVerificationAttributesResult)response.getAwsResponse();
            return getIdentityVerificationAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityDkimEnabledResult setIdentityDkimEnabled(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityDkimEnabledRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetIdentityDkimEnabledRequest> request = null;
        Response<SetIdentityDkimEnabledResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetIdentityDkimEnabledRequestMarshaller().marshall((SetIdentityDkimEnabledRequest)super.beforeMarshalling((AmazonWebServiceRequest)setIdentityDkimEnabledRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new SetIdentityDkimEnabledResultStaxUnmarshaller(), executionContext);
            SetIdentityDkimEnabledResult setIdentityDkimEnabledResult = (SetIdentityDkimEnabledResult)response.getAwsResponse();
            return setIdentityDkimEnabledResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSendQuotaResult getSendQuota(GetSendQuotaRequest getSendQuotaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSendQuotaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSendQuotaRequest> request = null;
        Response<GetSendQuotaResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSendQuotaRequestMarshaller().marshall((GetSendQuotaRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSendQuotaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetSendQuotaResultStaxUnmarshaller(), executionContext);
            GetSendQuotaResult getSendQuotaResult = (GetSendQuotaResult)response.getAwsResponse();
            return getSendQuotaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityFeedbackForwardingEnabledResult setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityFeedbackForwardingEnabledRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetIdentityFeedbackForwardingEnabledRequest> request = null;
        Response<SetIdentityFeedbackForwardingEnabledResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetIdentityFeedbackForwardingEnabledRequestMarshaller().marshall((SetIdentityFeedbackForwardingEnabledRequest)super.beforeMarshalling((AmazonWebServiceRequest)setIdentityFeedbackForwardingEnabledRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new SetIdentityFeedbackForwardingEnabledResultStaxUnmarshaller(), executionContext);
            SetIdentityFeedbackForwardingEnabledResult setIdentityFeedbackForwardingEnabledResult = (SetIdentityFeedbackForwardingEnabledResult)response.getAwsResponse();
            return setIdentityFeedbackForwardingEnabledResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyDomainIdentityResult verifyDomainIdentity(VerifyDomainIdentityRequest verifyDomainIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyDomainIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyDomainIdentityRequest> request = null;
        Response<VerifyDomainIdentityResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyDomainIdentityRequestMarshaller().marshall((VerifyDomainIdentityRequest)super.beforeMarshalling((AmazonWebServiceRequest)verifyDomainIdentityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new VerifyDomainIdentityResultStaxUnmarshaller(), executionContext);
            VerifyDomainIdentityResult verifyDomainIdentityResult = (VerifyDomainIdentityResult)response.getAwsResponse();
            return verifyDomainIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendEmailResult sendEmail(SendEmailRequest sendEmailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendEmailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendEmailRequest> request = null;
        Response<SendEmailResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendEmailRequestMarshaller().marshall((SendEmailRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendEmailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new SendEmailResultStaxUnmarshaller(), executionContext);
            SendEmailResult sendEmailResult = (SendEmailResult)response.getAwsResponse();
            return sendEmailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVerifiedEmailAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteVerifiedEmailAddressRequest> request = null;
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVerifiedEmailAddressRequestMarshaller().marshall((DeleteVerifiedEmailAddressRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVerifiedEmailAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityNotificationTopicResult setIdentityNotificationTopic(SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityNotificationTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetIdentityNotificationTopicRequest> request = null;
        Response<SetIdentityNotificationTopicResult> response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetIdentityNotificationTopicRequestMarshaller().marshall((SetIdentityNotificationTopicRequest)super.beforeMarshalling((AmazonWebServiceRequest)setIdentityNotificationTopicRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new SetIdentityNotificationTopicResultStaxUnmarshaller(), executionContext);
            SetIdentityNotificationTopicResult setIdentityNotificationTopicResult = (SetIdentityNotificationTopicResult)response.getAwsResponse();
            return setIdentityNotificationTopicResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses() throws AmazonServiceException, AmazonClientException {
        return this.listVerifiedEmailAddresses(new ListVerifiedEmailAddressesRequest());
    }

    @Override
    public GetSendStatisticsResult getSendStatistics() throws AmazonServiceException, AmazonClientException {
        return this.getSendStatistics(new GetSendStatisticsRequest());
    }

    @Override
    public ListIdentitiesResult listIdentities() throws AmazonServiceException, AmazonClientException {
        return this.listIdentities(new ListIdentitiesRequest());
    }

    @Override
    public GetSendQuotaResult getSendQuota() throws AmazonServiceException, AmazonClientException {
        return this.getSendQuota(new GetSendQuotaRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler responseHandler = new StaxResponseHandler(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, (HttpResponseHandler)responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

