/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codedeploy.model.CreateDeploymentRequest;
import com.amazonaws.services.codedeploy.model.GitHubLocation;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.S3Location;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDeploymentRequest, "AmazonCodeDeploy");
        String target = "CodeDeploy_20141006.CreateDeployment";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            RevisionLocation revision;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDeploymentRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value((Object)createDeploymentRequest.getApplicationName());
            }
            if (createDeploymentRequest.getDeploymentGroupName() != null) {
                jsonWriter.key("deploymentGroupName").value((Object)createDeploymentRequest.getDeploymentGroupName());
            }
            if ((revision = createDeploymentRequest.getRevision()) != null) {
                GitHubLocation gitHubLocation;
                S3Location s3Location;
                jsonWriter.key("revision");
                jsonWriter.object();
                if (revision.getRevisionType() != null) {
                    jsonWriter.key("revisionType").value((Object)revision.getRevisionType());
                }
                if ((s3Location = revision.getS3Location()) != null) {
                    jsonWriter.key("s3Location");
                    jsonWriter.object();
                    if (s3Location.getBucket() != null) {
                        jsonWriter.key("bucket").value((Object)s3Location.getBucket());
                    }
                    if (s3Location.getKey() != null) {
                        jsonWriter.key("key").value((Object)s3Location.getKey());
                    }
                    if (s3Location.getBundleType() != null) {
                        jsonWriter.key("bundleType").value((Object)s3Location.getBundleType());
                    }
                    if (s3Location.getVersion() != null) {
                        jsonWriter.key("version").value((Object)s3Location.getVersion());
                    }
                    if (s3Location.getETag() != null) {
                        jsonWriter.key("eTag").value((Object)s3Location.getETag());
                    }
                    jsonWriter.endObject();
                }
                if ((gitHubLocation = revision.getGitHubLocation()) != null) {
                    jsonWriter.key("gitHubLocation");
                    jsonWriter.object();
                    if (gitHubLocation.getRepository() != null) {
                        jsonWriter.key("repository").value((Object)gitHubLocation.getRepository());
                    }
                    if (gitHubLocation.getCommitId() != null) {
                        jsonWriter.key("commitId").value((Object)gitHubLocation.getCommitId());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (createDeploymentRequest.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value((Object)createDeploymentRequest.getDeploymentConfigName());
            }
            if (createDeploymentRequest.getDescription() != null) {
                jsonWriter.key("description").value((Object)createDeploymentRequest.getDescription());
            }
            if (createDeploymentRequest.isIgnoreApplicationStopFailures() != null) {
                jsonWriter.key("ignoreApplicationStopFailures").value((Object)createDeploymentRequest.isIgnoreApplicationStopFailures());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

