/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class CreateSubdomain {
    private final String name;
    private final String emailAddress;
    private final Optional<Integer> ttl;
    private final Optional<String> comment;

    private CreateSubdomain(String name, String email, Optional<Integer> ttl, Optional<String> comment) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name required");
        this.emailAddress = (String)Preconditions.checkNotNull((Object)email, (Object)"email required");
        this.ttl = ttl;
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.emailAddress;
    }

    public Optional<Integer> getTTL() {
        return this.ttl;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateSubdomain that = (CreateSubdomain)CreateSubdomain.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("email", (Object)this.emailAddress).add("ttl", this.ttl.orNull()).add("comment", this.comment.orNull());
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder {
        private String name;
        private String emailAddress;
        private Optional<Integer> ttl = Optional.absent();
        private Optional<String> comment = Optional.absent();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder email(String email) {
            this.emailAddress = email;
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = Optional.fromNullable((Object)ttl);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = Optional.fromNullable((Object)comment);
            return this;
        }

        public CreateSubdomain build() {
            return new CreateSubdomain(this.name, this.emailAddress, this.ttl, this.comment);
        }

        public Builder from(CreateSubdomain in) {
            return this.name(in.getName()).email(in.getEmail()).ttl((Integer)in.getTTL().orNull()).comment((String)in.getComment().orNull());
        }
    }
}

