/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoOptions;
import java.lang.reflect.Method;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.util.ReflectionUtils;

class ReflectiveMongoOptionsInvoker {
    private static final Method GET_AUTO_CONNECT_RETRY_METHOD;
    private static final Method SET_AUTO_CONNECT_RETRY_METHOD;
    private static final Method GET_MAX_AUTO_CONNECT_RETRY_TIME_METHOD;
    private static final Method SET_MAX_AUTO_CONNECT_RETRY_TIME_METHOD;

    private ReflectiveMongoOptionsInvoker() {
    }

    public static void setAutoConnectRetry(MongoOptions options, boolean autoConnectRetry) {
        if (MongoClientVersion.isMongo3Driver()) {
            return;
        }
        ReflectionUtils.invokeMethod((Method)SET_AUTO_CONNECT_RETRY_METHOD, (Object)options, (Object[])new Object[]{autoConnectRetry});
    }

    public static void setMaxAutoConnectRetryTime(MongoOptions options, long maxAutoConnectRetryTime) {
        if (MongoClientVersion.isMongo3Driver()) {
            return;
        }
        ReflectionUtils.invokeMethod((Method)SET_MAX_AUTO_CONNECT_RETRY_TIME_METHOD, (Object)options, (Object[])new Object[]{maxAutoConnectRetryTime});
    }

    public static void setSlaveOk(MongoOptions options, boolean slaveOk) {
        if (MongoClientVersion.isMongo3Driver()) {
            return;
        }
        new DirectFieldAccessor((Object)options).setPropertyValue("slaveOk", (Object)slaveOk);
    }

    public static boolean getSlaveOk(MongoOptions options) {
        if (MongoClientVersion.isMongo3Driver()) {
            throw new UnsupportedOperationException("Cannot get value for autoConnectRetry which has been removed in MongoDB Java driver version 3.");
        }
        return (Boolean)new DirectFieldAccessor((Object)options).getPropertyValue("slaveOk");
    }

    public static boolean getAutoConnectRetry(MongoOptions options) {
        if (MongoClientVersion.isMongo3Driver()) {
            throw new UnsupportedOperationException("Cannot get value for autoConnectRetry which has been removed in MongoDB Java driver version 3.");
        }
        return (Boolean)ReflectionUtils.invokeMethod((Method)GET_AUTO_CONNECT_RETRY_METHOD, (Object)options);
    }

    public static long getMaxAutoConnectRetryTime(MongoOptions options) {
        if (MongoClientVersion.isMongo3Driver()) {
            throw new UnsupportedOperationException("Cannot get value for maxAutoConnectRetryTime which has been removed in MongoDB Java driver version 3.");
        }
        return (Long)ReflectionUtils.invokeMethod((Method)GET_MAX_AUTO_CONNECT_RETRY_TIME_METHOD, (Object)options);
    }

    static {
        SET_AUTO_CONNECT_RETRY_METHOD = ReflectionUtils.findMethod(MongoOptions.class, (String)"setAutoConnectRetry", (Class[])new Class[]{Boolean.TYPE});
        GET_AUTO_CONNECT_RETRY_METHOD = ReflectionUtils.findMethod(MongoOptions.class, (String)"isAutoConnectRetry");
        SET_MAX_AUTO_CONNECT_RETRY_TIME_METHOD = ReflectionUtils.findMethod(MongoOptions.class, (String)"setMaxAutoConnectRetryTime", (Class[])new Class[]{Long.TYPE});
        GET_MAX_AUTO_CONNECT_RETRY_TIME_METHOD = ReflectionUtils.findMethod(MongoOptions.class, (String)"getMaxAutoConnectRetryTime");
    }
}

