/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSConfigurationException;
import com.thetransactioncompany.cors.environment.Environment;
import com.thetransactioncompany.cors.environment.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;

public class CORSConfigurationLoader {
    public static final String CONFIG_FILE_PARAM_NAME = "cors.configurationFile";
    private final FilterConfig filterConfig;
    private Environment environment;

    private static Properties getFilterInitParameters(FilterConfig config) {
        Properties props = new Properties();
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = config.getInitParameter(key);
            props.setProperty(key, value);
        }
        return props;
    }

    public CORSConfigurationLoader(FilterConfig filterConfig) {
        if (filterConfig == null) {
            throw new IllegalArgumentException("The servlet filter configuration must not be null");
        }
        this.filterConfig = filterConfig;
    }

    private Properties loadPropertiesFromFile(String filename) throws IOException {
        String correctedFilename = filename.startsWith("/") ? filename : "/" + filename;
        InputStream is = this.filterConfig.getServletContext().getResourceAsStream(correctedFilename);
        if (is == null) {
            throw new IOException("No such filename: " + correctedFilename);
        }
        Properties props = new Properties();
        props.load(is);
        is.close();
        return props;
    }

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new SystemProperties();
        }
        return this.environment;
    }

    public void setEnvironment(Environment env) {
        this.environment = env;
    }

    public CORSConfiguration load() throws CORSConfigurationException {
        Properties props;
        try {
            String configFile = this.getEnvironment().getProperty(CONFIG_FILE_PARAM_NAME);
            if (configFile == null || configFile.trim().isEmpty()) {
                configFile = this.filterConfig.getInitParameter(CONFIG_FILE_PARAM_NAME);
            }
            props = configFile != null ? this.loadPropertiesFromFile(configFile) : CORSConfigurationLoader.getFilterInitParameters(this.filterConfig);
        }
        catch (IOException e) {
            throw new CORSConfigurationException(e.getMessage(), e);
        }
        return new CORSConfiguration(props);
    }
}

