/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.lightcouch.Params;

class URIBuilder {
    private String scheme;
    private String host;
    private int port;
    private String path = "";
    private final StringBuilder query = new StringBuilder();
    private final List<String> qParams = new ArrayList<String>();

    URIBuilder() {
    }

    public static URIBuilder builder() {
        return new URIBuilder();
    }

    public static URIBuilder builder(URI uri) {
        URIBuilder builder = URIBuilder.builder().scheme(uri.getScheme()).host(uri.getHost()).port(uri.getPort()).path(uri.getPath());
        return builder;
    }

    public URI build() {
        try {
            for (int i = 0; i < this.qParams.size(); ++i) {
                String amp = i != this.qParams.size() - 1 ? "&" : "";
                this.query.append(this.qParams.get(i) + amp);
            }
            String q = this.query.length() == 0 ? null : this.query.toString();
            return new URI(this.scheme, null, this.host, this.port, this.path, q, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URIBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public URIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public URIBuilder path(String path) {
        this.path = this.path + path;
        return this;
    }

    public URIBuilder query(String name, Object value) {
        if (name != null && value != null) {
            this.qParams.add(String.format("%s=%s", name, value));
        }
        return this;
    }

    public URIBuilder query(String query) {
        if (query != null) {
            this.query.append(query);
        }
        return this;
    }

    public URIBuilder query(Params params) {
        if (params.getParams() != null) {
            this.qParams.addAll(params.getParams());
        }
        return this;
    }
}

