/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.lightcouch.Changes;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbConfig;
import org.lightcouch.CouchDbContext;
import org.lightcouch.CouchDbDesign;
import org.lightcouch.CouchDbException;
import org.lightcouch.CouchDbProperties;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.DocumentConflictException;
import org.lightcouch.NoDocumentException;
import org.lightcouch.Params;
import org.lightcouch.Replication;
import org.lightcouch.Replicator;
import org.lightcouch.Response;
import org.lightcouch.URIBuilder;
import org.lightcouch.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CouchDbClientBase {
    static final Log log = LogFactory.getLog(CouchDbClient.class);
    private URI baseURI;
    private URI dbURI;
    private Gson gson;
    private CouchDbContext context;
    private CouchDbDesign design;
    final HttpClient httpClient;
    final HttpHost host;

    CouchDbClientBase() {
        this(new CouchDbConfig());
    }

    CouchDbClientBase(CouchDbConfig config) {
        CouchDbProperties props = config.getProperties();
        this.httpClient = this.createHttpClient(props);
        this.gson = this.initGson(new GsonBuilder());
        this.host = new HttpHost(props.getHost(), props.getPort(), props.getProtocol());
        String path = props.getPath() != null ? props.getPath() : "";
        this.baseURI = URIBuilder.builder().scheme(props.getProtocol()).host(props.getHost()).port(props.getPort()).path("/").path(path).build();
        this.dbURI = URIBuilder.builder(this.baseURI).path(props.getDbName()).path("/").build();
        this.context = new CouchDbContext(this, props);
        this.design = new CouchDbDesign(this);
    }

    abstract HttpClient createHttpClient(CouchDbProperties var1);

    abstract HttpContext createContext();

    abstract void shutdown();

    public CouchDbContext context() {
        return this.context;
    }

    public CouchDbDesign design() {
        return this.design;
    }

    public View view(String viewId) {
        return new View(this, viewId);
    }

    public Replication replication() {
        return new Replication(this);
    }

    public Replicator replicator() {
        return new Replicator(this);
    }

    public Changes changes() {
        return new Changes(this);
    }

    public <T> T find(Class<T> classType, String id) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        return this.get(URIBuilder.builder(this.getDBUri()).path(id).build(), classType);
    }

    public <T> T find(Class<T> classType, String id, Params params) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        return this.get(URIBuilder.builder(this.getDBUri()).path(id).query(params).build(), classType);
    }

    public <T> T find(Class<T> classType, String id, String rev) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(id, "rev");
        URI uri = URIBuilder.builder(this.getDBUri()).path(id).query("rev", rev).build();
        return this.get(uri, classType);
    }

    public <T> T findAny(Class<T> classType, String uri) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(uri, "uri");
        return this.get(URI.create(uri), classType);
    }

    public InputStream find(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        return this.get(URIBuilder.builder(this.getDBUri()).path(id).build());
    }

    public InputStream find(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        return this.get(URIBuilder.builder(this.getDBUri()).path(id).query("rev", rev).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        HttpResponse response = null;
        try {
            response = this.head(URIBuilder.builder(this.getDBUri()).path(id).build());
            CouchDbUtil.close(response);
        }
        catch (NoDocumentException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            CouchDbUtil.close(response);
        }
        return true;
    }

    public Response save(Object object) {
        return this.put(this.getDBUri(), object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(Object object) {
        CouchDbUtil.assertNotEmpty(object, "object");
        HttpResponse response = null;
        try {
            URI uri = URIBuilder.builder(this.getDBUri()).query("batch", "ok").build();
            response = this.post(uri, this.getGson().toJson(object));
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
    }

    public Response update(Object object) {
        return this.put(this.getDBUri(), object, false);
    }

    public Response remove(Object object) {
        CouchDbUtil.assertNotEmpty(object, "object");
        JsonObject jsonObject = this.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(jsonObject, "_id");
        String rev = CouchDbUtil.getAsString(jsonObject, "_rev");
        return this.remove(id, rev);
    }

    public Response remove(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        return this.delete(URIBuilder.builder(this.getDBUri()).path(id).query("rev", rev).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Response> bulk(List<?> objects, boolean allOrNothing) {
        List<Response> list;
        CouchDbUtil.assertNotEmpty(objects, "objects");
        HttpResponse response = null;
        try {
            String allOrNothingVal = allOrNothing ? "\"all_or_nothing\": true, " : "";
            URI uri = URIBuilder.builder(this.getDBUri()).path("_bulk_docs").build();
            String json = String.format("{%s%s%s}", allOrNothingVal, "\"docs\": ", this.getGson().toJson(objects));
            response = this.post(uri, json);
            list = this.getResponseList(response);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
        return list;
    }

    public Response saveAttachment(InputStream instream, String name, String contentType) {
        CouchDbUtil.assertNotEmpty(instream, "InputStream");
        CouchDbUtil.assertNotEmpty(name, "name");
        CouchDbUtil.assertNotEmpty(contentType, "ContentType");
        URI uri = URIBuilder.builder(this.getDBUri()).path(CouchDbUtil.generateUUID()).path("/").path(name).build();
        return this.put(uri, instream, contentType);
    }

    public Response saveAttachment(InputStream instream, String name, String contentType, String docId, String docRev) {
        CouchDbUtil.assertNotEmpty(instream, "InputStream");
        CouchDbUtil.assertNotEmpty(name, "name");
        CouchDbUtil.assertNotEmpty(contentType, "ContentType");
        CouchDbUtil.assertNotEmpty(docId, "DocId");
        URI uri = URIBuilder.builder(this.getDBUri()).path(docId).path("/").path(name).query("rev", docRev).build();
        return this.put(uri, instream, contentType);
    }

    public String invokeUpdateHandler(String updateHandlerUri, String docId, String query) {
        CouchDbUtil.assertNotEmpty(updateHandlerUri, "updateHandlerUri");
        CouchDbUtil.assertNotEmpty(docId, "docId");
        String[] v = updateHandlerUri.split("/");
        String path = String.format("_design/%s/_update/%s/%s", v[0], v[1], docId);
        URI uri = URIBuilder.builder(this.getDBUri()).path(path).query(query).build();
        HttpResponse response = this.executeRequest((HttpRequestBase)new HttpPut(uri));
        return CouchDbUtil.streamToString(CouchDbUtil.getStream(response));
    }

    public HttpResponse executeRequest(HttpRequestBase request) {
        try {
            return this.httpClient.execute(this.host, (HttpRequest)request, this.createContext());
        }
        catch (IOException e) {
            request.abort();
            throw new CouchDbException("Error executing request. ", e);
        }
    }

    public void syncDesignDocsWithDb() {
        this.design().synchronizeAllWithDb();
    }

    public void setGsonBuilder(GsonBuilder gsonBuilder) {
        this.gson = this.initGson(gsonBuilder);
    }

    public URI getBaseUri() {
        return this.baseURI;
    }

    public URI getDBUri() {
        return this.dbURI;
    }

    public Gson getGson() {
        return this.gson;
    }

    InputStream get(HttpGet httpGet) {
        HttpResponse response = this.executeRequest((HttpRequestBase)httpGet);
        return CouchDbUtil.getStream(response);
    }

    InputStream get(URI uri) {
        HttpGet get = new HttpGet(uri);
        get.addHeader("Accept", "application/json");
        return this.get(get);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T get(URI uri, Class<T> classType) {
        InputStream in = null;
        try {
            in = this.get(uri);
            Object object = this.getGson().fromJson((Reader)new InputStreamReader(in), classType);
            return (T)object;
        }
        finally {
            CouchDbUtil.close(in);
        }
    }

    HttpResponse head(URI uri) {
        return this.executeRequest((HttpRequestBase)new HttpHead(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response put(URI uri, Object object, boolean newEntity) {
        Response response;
        CouchDbUtil.assertNotEmpty(object, "object");
        HttpResponse response2 = null;
        try {
            JsonObject json = this.getGson().toJsonTree(object).getAsJsonObject();
            String id = CouchDbUtil.getAsString(json, "_id");
            String rev = CouchDbUtil.getAsString(json, "_rev");
            if (newEntity) {
                CouchDbUtil.assertNull(rev, "revision");
                id = id == null ? CouchDbUtil.generateUUID() : id;
            } else {
                CouchDbUtil.assertNotEmpty(id, "id");
                CouchDbUtil.assertNotEmpty(rev, "revision");
            }
            HttpPut put = new HttpPut(URIBuilder.builder(uri).path(id).build());
            this.setEntity((HttpEntityEnclosingRequestBase)put, json.toString());
            response2 = this.executeRequest((HttpRequestBase)put);
            response = this.getResponse(response2);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response put(URI uri, InputStream instream, String contentType) {
        Response response;
        HttpResponse response2 = null;
        try {
            HttpPut httpPut = new HttpPut(uri);
            InputStreamEntity entity = new InputStreamEntity(instream, -1L);
            entity.setContentType(contentType);
            httpPut.setEntity((HttpEntity)entity);
            response2 = this.executeRequest((HttpRequestBase)httpPut);
            response = this.getResponse(response2);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    HttpResponse post(URI uri, String json) {
        HttpPost post = new HttpPost(uri);
        this.setEntity((HttpEntityEnclosingRequestBase)post, json);
        return this.executeRequest((HttpRequestBase)post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response delete(URI uri) {
        Response response;
        HttpResponse response2 = null;
        try {
            HttpDelete delete = new HttpDelete(uri);
            response2 = this.executeRequest((HttpRequestBase)delete);
            response = this.getResponse(response2);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    void validate(HttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code == 200 || code == 201 || code == 202) {
            return;
        }
        String reason = response.getStatusLine().getReasonPhrase();
        switch (code) {
            case 404: {
                throw new NoDocumentException(reason);
            }
            case 409: {
                throw new DocumentConflictException(reason);
            }
        }
        reason = reason + EntityUtils.toString((HttpEntity)response.getEntity());
        throw new CouchDbException(reason);
    }

    private Response getResponse(HttpResponse response) throws CouchDbException {
        InputStreamReader reader = new InputStreamReader(CouchDbUtil.getStream(response));
        return (Response)this.getGson().fromJson((Reader)reader, Response.class);
    }

    private List<Response> getResponseList(HttpResponse response) throws CouchDbException {
        InputStream instream = CouchDbUtil.getStream(response);
        InputStreamReader reader = new InputStreamReader(instream);
        return (List)this.getGson().fromJson((Reader)reader, new TypeToken<List<Response>>(){}.getType());
    }

    private void setEntity(HttpEntityEnclosingRequestBase httpRequest, String json) {
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentType("application/json");
        httpRequest.setEntity((HttpEntity)entity);
    }

    private Gson initGson(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(JsonObject.class, (Object)new JsonDeserializer<JsonObject>(){

            public JsonObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return json.getAsJsonObject();
            }
        });
        gsonBuilder.registerTypeAdapter(JsonObject.class, (Object)new JsonSerializer<JsonObject>(){

            public JsonElement serialize(JsonObject src, Type typeOfSrc, JsonSerializationContext context) {
                return src.getAsJsonObject();
            }
        });
        return gsonBuilder.create();
    }
}

