/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlKeygen;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRp;
import com.gargoylesoftware.htmlunit.html.HtmlRt;
import com.gargoylesoftware.htmlunit.html.HtmlUnknownElement;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.NativeFunctionPrefixResolver;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMImplementation;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.dom.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.dom.XPathResult;
import com.gargoylesoftware.htmlunit.javascript.host.event.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLAnchorElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.utils.PrefixResolver;
import org.w3c.dom.DocumentType;

@JsxClass
public class Document
extends EventNode {
    private static final Log LOG = LogFactory.getLog(Document.class);
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("\\w+");
    private Window window_;
    private DOMImplementation implementation_;
    private String designMode_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public Document() {
    }

    public void setWindow(Window window) {
        this.window_ = window;
    }

    @JsxGetter
    public Location getLocation() {
        return this.window_.getLocation();
    }

    @JsxSetter
    public void setLocation(String location) throws IOException {
        String href;
        Object target;
        Object event = this.getWindow().getEvent();
        boolean setLocation = true;
        if (event instanceof UIEvent && (target = ((UIEvent)event).getTarget()) instanceof HTMLAnchorElement && !(href = ((HTMLAnchorElement)target).getHref()).isEmpty() && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_SET_LOCATION_EXECUTED_IN_ANCHOR)) {
            setLocation = false;
        }
        if (setLocation) {
            this.window_.setLocation(location);
        }
    }

    @JsxGetter
    public String getReferrer() {
        String referrer = this.getPage().getWebResponse().getWebRequest().getAdditionalHeaders().get("Referer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    @JsxGetter
    public Element getDocumentElement() {
        DomElement documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return (Element)this.getScriptableFor(documentElement);
    }

    @JsxGetter
    public SimpleScriptable getDoctype() {
        DocumentType documentType = this.getPage().getDoctype();
        if (documentType == null) {
            return null;
        }
        return this.getScriptableFor(documentType);
    }

    @JsxGetter
    public String getDesignMode() {
        if (this.designMode_ == null) {
            this.designMode_ = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DESIGN_MODE_INHERIT) ? "inherit" : "off";
        }
        return this.designMode_;
    }

    @JsxSetter
    public void setDesignMode(String mode) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        boolean inherit = browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DESIGN_MODE_INHERIT);
        if (inherit) {
            if (!("on".equalsIgnoreCase(mode) || "off".equalsIgnoreCase(mode) || "inherit".equalsIgnoreCase(mode))) {
                throw Context.reportRuntimeError((String)("Invalid document.designMode value '" + mode + "'."));
            }
            if ("on".equalsIgnoreCase(mode)) {
                this.designMode_ = "on";
            } else if ("off".equalsIgnoreCase(mode)) {
                this.designMode_ = "off";
            } else if ("inherit".equalsIgnoreCase(mode)) {
                this.designMode_ = "inherit";
            }
        } else if ("on".equalsIgnoreCase(mode)) {
            this.designMode_ = "on";
            SgmlPage page = this.getPage();
            if (page != null && page.isHtmlPage() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_SELECTION_RANGE_COUNT)) {
                HtmlPage htmlPage = (HtmlPage)page;
                DomNode child = htmlPage.getBody().getFirstChild();
                DomNode rangeNode = child == null ? htmlPage.getBody() : child;
                htmlPage.setSelectionRange(new SimpleRange(rangeNode, 0));
            }
        } else if ("off".equalsIgnoreCase(mode)) {
            this.designMode_ = "off";
        }
    }

    public SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    @JsxGetter
    public Object getDefaultView() {
        return this.getWindow();
    }

    @JsxFunction
    public Object createDocumentFragment() {
        DomDocumentFragment fragment = this.getDomNodeOrDie().getPage().createDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    @JsxFunction
    public Attr createAttribute(String attributeName) {
        return (Attr)this.getPage().createAttribute(attributeName).getScriptableObject();
    }

    @JsxFunction
    public Object importNode(Node importedNode, boolean deep) {
        DomNode domNode = importedNode.getDomNodeOrDie();
        domNode = domNode.cloneNode(deep);
        domNode.processImportNode(this);
        for (DomNode childNode : domNode.getDescendants()) {
            childNode.processImportNode(this);
        }
        return domNode.getScriptableObject();
    }

    @JsxFunction
    public Object adoptNode(Node externalNode) {
        externalNode.remove();
        return this.importNode(externalNode, true);
    }

    @JsxGetter
    public DOMImplementation getImplementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(this.implementation_.getClass()));
        }
        return this.implementation_;
    }

    @JsxFunction
    public void captureEvents(String type) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction
    public Object createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(this.getDomNodeOrDie().getPage(), newData);
            SimpleScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domNode.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction
    public Object createComment(String comment) {
        DomComment domNode = new DomComment(this.getDomNodeOrDie().getPage(), comment);
        return this.getScriptableFor(domNode);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public XPathResult evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)result;
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
        }
        PrefixResolver prefixResolver = null;
        if (resolver instanceof NativeFunction) {
            prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, contextNode.getParentScope());
        } else if (resolver instanceof PrefixResolver) {
            prefixResolver = (PrefixResolver)resolver;
        }
        xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression, prefixResolver), type);
        return xPathResult;
    }

    @JsxFunction
    public Object createElement(String tagName) {
        Object result = NOT_FOUND;
        try {
            Matcher matcher;
            BrowserVersion browserVersion = this.getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_CREATE_ELEMENT_STRICT) && (tagName.contains("<") || tagName.contains(">"))) {
                LOG.info((Object)("createElement: Provided string '" + tagName + "' contains an invalid character; '<' and '>' are not allowed"));
                throw Context.reportRuntimeError((String)"String contains an invalid character");
            }
            if (tagName.startsWith("<") && tagName.endsWith(">") && !(matcher = TAG_NAME_PATTERN.matcher(tagName = tagName.substring(1, tagName.length() - 1))).matches()) {
                LOG.info((Object)("createElement: Provided string '" + tagName + "' contains an invalid character"));
                throw Context.reportRuntimeError((String)"String contains an invalid character");
            }
            SgmlPage page = this.getPage();
            org.w3c.dom.Element element = page.createElement(tagName);
            if (element instanceof BaseFrameElement) {
                ((BaseFrameElement)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlInput) {
                ((HtmlInput)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlImage) {
                ((HtmlImage)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlKeygen) {
                ((HtmlKeygen)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRp) {
                ((HtmlRp)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlRt) {
                ((HtmlRt)element).markAsCreatedByJavascript();
            } else if (element instanceof HtmlUnknownElement) {
                ((HtmlUnknownElement)element).markAsCreatedByJavascript();
            }
            SimpleScriptable jsElement = this.getScriptableFor(element);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + element.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction
    public Object createElementNS(String namespaceURI, String qualifiedName) {
        if ("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI)) {
            throw Context.reportRuntimeError((String)"XUL not available");
        }
        org.w3c.dom.Element element = "http://www.w3.org/1999/xhtml".equals(namespaceURI) || "http://www.w3.org/2000/svg".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null);
        return this.getScriptableFor(element);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(final String tagName) {
        HTMLCollection collection = "*".equals(tagName) ? new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return true;
            }
        } : new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagName.equalsIgnoreCase(node.getNodeName());
            }
        };
        return collection;
    }

    @JsxFunction
    public Object getElementsByTagNameNS(Object namespaceURI, final String localName) {
        final String prefix = namespaceURI != null && !"*".equals(namespaceURI) ? XmlUtil.lookupPrefix(this.getPage().getDocumentElement(), Context.toString((Object)namespaceURI)) : null;
        HTMLCollection collection = new HTMLCollection(this.getDomNodeOrDie(), false){

            @Override
            protected boolean isMatching(DomNode node) {
                if (!localName.equals(node.getLocalName())) {
                    return false;
                }
                if (prefix == null) {
                    return true;
                }
                return true;
            }
        };
        return collection;
    }
}

