/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBuffer;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.Uint8ClampedArray;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;

@JsxClass
public class ImageData
extends SimpleScriptable {
    private final RenderingBackend renderingContext_;
    private final int sx_;
    private final int sy_;
    private final int width_;
    private final int height_;
    private Uint8ClampedArray data_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public ImageData() {
        this(null, 0, 0, 0, 0);
    }

    ImageData(RenderingBackend context, int x, int y, int width, int height) {
        this.renderingContext_ = context;
        this.sx_ = x;
        this.sy_ = y;
        this.width_ = width;
        this.height_ = height;
    }

    @JsxGetter
    public int getWidth() {
        return this.width_;
    }

    @JsxGetter
    public int getHeight() {
        return this.height_;
    }

    @JsxGetter
    public Uint8ClampedArray getData() {
        if (this.data_ == null) {
            byte[] bytes = this.renderingContext_.getBytes(this.width_, this.height_, this.sx_, this.sy_);
            ArrayBuffer arrayBuffer = new ArrayBuffer();
            arrayBuffer.constructor(bytes.length);
            arrayBuffer.setBytes(0, bytes);
            this.data_ = new Uint8ClampedArray();
            this.data_.setParentScope(this.getParentScope());
            this.data_.setPrototype(this.getPrototype(this.data_.getClass()));
            this.data_.constructor((Object)arrayBuffer, (Object)0, (Object)bytes.length);
        }
        return this.data_;
    }
}

