/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class NamedNodeMap
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private final org.w3c.dom.NamedNodeMap attributes_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public NamedNodeMap() {
        this.attributes_ = null;
    }

    public NamedNodeMap(DomElement element) {
        this.setParentScope((Scriptable)element.getScriptableObject());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributes_ = element.getAttributes();
        this.setDomNode(element, false);
    }

    public final Object get(int index, Scriptable start) {
        NamedNodeMap startMap = (NamedNodeMap)start;
        Object response = startMap.item(index);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    @Override
    public Object getWithFallback(String name) {
        Object response = this.getNamedItem(name);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    public Object getNamedItemWithoutSytheticClassAttr(String name) {
        DomNode attr;
        if (this.attributes_ != null && (attr = (DomNode)this.attributes_.getNamedItem(name)) != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object getNamedItem(String name) {
        Object attr = this.getNamedItemWithoutSytheticClassAttr(name);
        if (null != attr) {
            return attr;
        }
        return null;
    }

    @JsxFunction
    public void setNamedItem(Node node) {
        this.attributes_.setNamedItem(node.getDomNodeOrDie());
    }

    @JsxFunction
    public void removeNamedItem(String name) {
        this.attributes_.removeNamedItem(name);
    }

    @JsxFunction
    public Object item(int index) {
        DomNode attr = (DomNode)this.attributes_.item(index);
        if (attr != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public int getLength() {
        return this.attributes_.getLength();
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getLength();
    }
}

