/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import com.gargoylesoftware.htmlunit.html.impl.SimpleSelectionDelegate;
import java.io.PrintWriter;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class DomText
extends DomCharacterData
implements Text {
    private SelectionDelegate selectionDelegate_;
    private DoTypeProcessor doTypeProcessor_;
    public static final String NODE_NAME = "#text";

    public DomText(SgmlPage page, String data) {
        super(page, data);
    }

    @Override
    public DomText splitText(int offset) {
        if (offset < 0 || offset > this.getLength()) {
            throw new IllegalArgumentException("offset: " + offset + " data.length: " + this.getLength());
        }
        DomText newText = this.createSplitTextNode(offset);
        this.setData(this.getData().substring(0, offset));
        if (this.getParentNode() != null) {
            this.getParentNode().insertBefore(newText, this.getNextSibling());
        }
        return newText;
    }

    protected DomText createSplitTextNode(int offset) {
        return new DomText(this.getPage(), this.getData().substring(offset));
    }

    @Override
    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("DomText.isElementContentWhitespace is not yet implemented.");
    }

    @Override
    public String getWholeText() {
        return this.getNodeValue();
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        throw new UnsupportedOperationException("DomText.replaceWholeText is not yet implemented.");
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        String data = this.getData();
        if (StringUtils.isNotBlank((CharSequence)data)) {
            printWriter.print(indent);
            if (!(this.getParentNode() instanceof HtmlStyle && data.startsWith("<!--") && data.endsWith("-->"))) {
                data = com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlChars(data);
            }
            printWriter.print(data);
            printWriter.print("\r\n");
        }
        this.printChildrenAsXml(indent, printWriter);
    }

    public String toString() {
        return this.asText();
    }

    @Override
    protected boolean isTrimmedText() {
        return false;
    }

    protected void doType(char c, boolean startAtEnd, HtmlElement htmlElement) {
        this.initDoTypeProcessor();
        if (startAtEnd) {
            this.selectionDelegate_.setSelectionStart(this.getData().length());
        }
        this.doTypeProcessor_.doType(this.getData(), this.selectionDelegate_, c, htmlElement);
    }

    protected void doType(int keyCode, boolean startAtEnd, HtmlElement htmlElement) {
        this.initDoTypeProcessor();
        if (startAtEnd) {
            this.selectionDelegate_.setSelectionStart(this.getData().length());
        }
        this.doTypeProcessor_.doType(this.getData(), this.selectionDelegate_, keyCode, htmlElement);
    }

    private void initDoTypeProcessor() {
        if (this.selectionDelegate_ == null) {
            this.selectionDelegate_ = new SimpleSelectionDelegate();
            this.doTypeProcessor_ = new DoTypeProcessor(this);
        }
    }

    protected boolean acceptChar(char c) {
        return !(c >= '\ue000' && c <= '\uf8ff' || c != ' ' && Character.isWhitespace(c));
    }
}

