/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebResponse
implements Serializable {
    private static final Log LOG = LogFactory.getLog(WebResponse.class);
    private long loadTime_;
    private WebResponseData responseData_;
    private WebRequest request_;

    public WebResponse(WebResponseData responseData, URL url, HttpMethod requestMethod, long loadTime) {
        this(responseData, new WebRequest(url, requestMethod), loadTime);
    }

    public WebResponse(WebResponseData responseData, WebRequest request, long loadTime) {
        this.responseData_ = responseData;
        this.request_ = request;
        this.loadTime_ = loadTime;
    }

    public WebRequest getWebRequest() {
        return this.request_;
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    public String getResponseHeaderValue(String headerName) {
        for (NameValuePair pair : this.responseData_.getResponseHeaders()) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContentCharsetOrNull() {
        try (InputStream is = this.getContentAsStream();){
            String string = EncodingSniffer.sniffEncoding(this.getResponseHeaders(), is);
            return string;
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to sniff encoding.", (Throwable)e);
            return null;
        }
    }

    public String getContentCharset() {
        String charset = this.getContentCharsetOrNull();
        if (charset == null) {
            String contentType = this.getContentType();
            if (null != contentType && DefaultPageCreator.PageType.XML == DefaultPageCreator.determinePageType(contentType)) {
                return "UTF-8";
            }
            charset = this.getWebRequest().getCharset();
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public String getContentAsString() {
        return this.getContentAsString(this.getContentCharset());
    }

    public String getContentAsString(String encoding) {
        return this.getContentAsString(encoding, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public String getContentAsString(String encoding, String defaultEncoding) {
        try {
            Throwable throwable = null;
            try (InputStream in = this.responseData_.getInputStream();){
                if (null == in) {
                    String string = null;
                    return string;
                }
                try {
                    Charset.forName(encoding);
                }
                catch (Exception e) {
                    String string;
                    block30: {
                        block31: {
                            if (encoding.equals(defaultEncoding)) {
                                LOG.warn((Object)e);
                                String x2 = "";
                                if (in != null) {
                                    if (throwable != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable x22) {
                                            throwable.addSuppressed(x22);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                return x2;
                            }
                            String cs = defaultEncoding != null ? defaultEncoding : this.getContentCharset();
                            LOG.warn((Object)("Attempted to use unsupported encoding '" + encoding + "'; using default content charset ('" + cs + "')."));
                            string = IOUtils.toString((InputStream)in, (String)cs);
                            if (in == null) break block30;
                            if (throwable == null) break block31;
                            try {
                                in.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            break block30;
                        }
                        in.close();
                    }
                    return string;
                }
                String string = IOUtils.toString((InputStream)in, (String)encoding);
                return string;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)e);
            return null;
        }
    }

    public long getContentLength() {
        if (this.responseData_ == null) {
            return 0L;
        }
        return this.responseData_.getContentLength();
    }

    public InputStream getContentAsStream() throws IOException {
        return this.responseData_.getInputStream();
    }

    public long getLoadTime() {
        return this.loadTime_;
    }

    public void cleanUp() {
        if (this.responseData_ != null) {
            this.responseData_.cleanUp();
        }
    }
}

