<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('users')?>"><h3><?=$data['title']?></h3></a></li>
                <li><span><?=$data['crumb1']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <span class="hide csrf_token"><?=$data['csrf_token']?></span>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('Block Multiple Users', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="form-group">
                        <label for="userNames"><?=Language::show('userNames', 'keywords');?></label><br/>
                        <select class="blockUserNames" name="blockUserNames[]" style="width: 100%;" id="userNames" multiple="multiple" required></select>
                    </div>
                    <div class="form-group">
                        <a ng-click="blockUnBlockMultipleUsers(false)" class="block btn btn-danger"><i class="fa fa-save"></i> Block</a>
                        <a class="btn btn-default" href="<?=Url::basePath('users')?>"><i class="fa fa-times"></i> Cancel</a>
                    </div>
                </div>
            </div>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('Delete/Unblock Multiple Users', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="form-group">
                        <label for="userNames"><?=Language::show('userNames', 'keywords');?></label><br/>
                        <select class="deleteUserNames" name="deleteUserNames[]" style="width: 100%;" id="userNames" multiple="multiple" required></select>
                    </div>
                    <div class="form-group">
                        <a ng-click="blockUnBlockMultipleUsers(true)" class="unblock btn btn-success"><i class="fa fa-save"></i> UnBlock</a>
                        <a ng-click="deleteMultipleUsers()" class="delete btn btn-danger"><i class="fa fa-save"></i> Delete</a>
                        <a class="btn btn-default" href="<?=Url::basePath('users')?>"><i class="fa fa-times"></i> Cancel</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $(".deleteUserNames").select2({
        ajax: {
            url: "<?=DIR?>"+"user/getAllBlockedUsers",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data.users);
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    $(".blockUserNames").select2({
        ajax: {
            url: "<?=DIR?>"+"user/getAllUnBlockedUsers",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>