<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('servers')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('server/attachContainer/'.$data['deviceName'].'/'.$data['deviceUUID'])?>">Containers</a></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ServerController">
    <span class="hide currentPage"><?='restore'?></span>
    <span class="hide ngTracker"><?='backup'?></span>
    <span class="hide selectedContainerType"><?=$_SESSION['selectedContainerType']?></span>
    <?php if($_SESSION['admin'] == true){ ?>
        <span class="hide userType"><?='admin'?></span>
    <?php }elseif($_SESSION['readOnlyAdmin'] == true){ ?>
        <span class="hide userType"><?='readOnlyAdmin'?></span>
    <?php }else{ ?>
        <span class="hide userType"><?='user'?></span>
    <?php } ?>
    <span class="hide deviceUUID"><?=$data['deviceUUID']?></span>
    <span class="hide currentDeviceName"><?=$data['deviceName']?></span>
    <span class="hide containerName"><?=$data['containerName']?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 filePanel">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav nav-breadcrumb" id="breadCrumb">
                        <li><a href="javascript:;" ng-click="updateFileList('root','root', true, false, 'root')"><i class="fa fa-home"></i> <?=$data['containerName']?></a></li>
                        <li ng-repeat="value in crumb track by $index"><a href="javascript:;" ng-click="updateFileListFromBreadCrumb(value, $index)" class="toolTip" data-toggle="tooltip" data-placement="top" data-original-title="{{ value }}">{{ value }}</a></li>
                    </ul>
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <?php if($_SESSION['readOnlyAdmin'] != true){ ?>
<!--                            <li><a ng-click="addToRestore()" class="toolTip addBtn" data-toggle="tooltip" data-placement="top" title="Add to Restore" href="javascript:;"><i class="fa fa-plus-square"></i></a></li>-->
<!--                            <li><a ng-click="getVersions()" class="toolTip versionsBtn" style="display: none" data-toggle="tooltip" data-placement="top" title="Versions" href="javascript:;"><i class="fa fa-clock-o"></i></a></li>-->
                        <?php } ?>
                        <!--                        <li ng-if="selectedFileForRestoreList.length >= 1"><a ng-click="initiateRestore('--><?//=$_SESSION['currentDeviceId']?><!--')" class="toolTip restoreBtn" data-toggle="tooltip" data-placement="top" title="Restore Selected Files" href="javascript:;"><i class="fa fa-recycle"></i></a></li>-->
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow backupFilesTable" style="display:none">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-xs-5">
                            <col class="col-xs-2">
                            <col class="col-xs-3">
                            <col class="col-xs-2">
                        </colgroup>
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'name'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'name' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'name' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'type'; sortReverse = !sortReverse">
                                Type
                                <span ng-show="sortType == 'type' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'type' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'serverModifiedTime'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'serverModifiedTime' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'serverModifiedTime' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'size'; sortReverse = !sortReverse">
                                Size
                                <span ng-show="sortType == 'size' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'size' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'tr', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse track by $index">
                            <td data-name="{{value.name}}" ng-if="value.type == 'Folder'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(value.fullPath, value.name, true, false, $index)" style="cursor: pointer; color: #585f69;"><span ng-cloak ng-bind-html="value.name | charLimit"></span></a></td>
                            <td data-name="{{value.name}}" ng-if="value.type == 'File'"><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.name | charLimit"></span></a></td>
                            <td> {{ value.type }} </td>
                            <td> {{ value.serverModifiedTime }} </td>
                            <td ng-if="value.type == 'Folder'"> - </td>
                            <td ng-if="value.type == 'File'">
                                {{ value.size }}
                                <span ng-if="value.storagePlace == 'PG'" class="text-warning"> <span class="text-warning"><i class="fa fa-warning"></i></span></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="panel-footer" ng-if="items.length > 0">
                    <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-warning"></i></span> means that the particular file has not yet been moved to Cloud.</p>
                </div>
            </div>
            <div class="modal fade whiteAndBigModal backupFileVersions">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">
                                File Versions list - File Name: <span>{{ selected[0].name }}</span>
                            </h4>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive" style="margin-top: -20px;">
                                <hr/>
                                <div class="h4 loading text-center">Loading.....</div>
                                <table class="table table-bordered table-striped deviceHistoryDetailsTable" style="display: none;">
                                    <thead>
                                        <tr>
                                            <th><?=Language::show('version', 'keywords')?></th>
                                            <th><?=Language::show('time', 'keywords')?></th>
                                            <th><?=Language::show('file_size', 'keywords')?></th>
                                            <?php if($_SESSION['readOnlyAdmin'] != true){ ?>
                                                <th><?=Language::show('action', 'keywords')?></th>
                                            <?php }?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr ng-repeat="value in fileVersions track by $index">
                                            <td ng-if="value.status == 'ADDED'" ng-cloak>{{ value.version + (fileVersions.length-$index)}} <span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-warning"></i></span></td>
                                            <td ng-if="value.status == 'MODIFIED'" ng-cloak>{{ value.version + (fileVersions.length-$index)}} <span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-warning"></i></span></td>
                                            <td ng-if="value.status == 'DELETED'" ng-cloak><span style="text-decoration: line-through;">{{ value.version + (fileVersions.length-$index)}} <span ng-if="value.storagePlace.length <= 0 || value.storagePlace == undefined" class="text-warning"><i class="fa fa-warning"></i></span></span></td>
                                            <td ng-cloak>{{ value.serverModifiedTime }}</td>
                                            <td ng-cloak><span class="text-info">{{ value.size }}</span></td>
                                            <?php if($_SESSION['readOnlyAdmin'] != true){ ?>
                                                <td ng-cloak ng-if="value.status != 'DELETED'"><a class="btn btn-primary btn-small" ng-click="addToRestoreBackupFromRevisions($index, (fileVersions.length-$index))">Add to Restore</a></td>
                                                <td ng-cloak ng-if="value.status == 'DELETED'">-</td>
                                            <?php } ?>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-warning"></i></span> means that the particular file has not yet been moved to Cloud.</p>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade deleteConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <p>
                                <span ng-repeat="value in selected track by $index">
                                    <span ng-if="$index == (selected.length - 1)">{{ value.name }}</span>
                                    <span ng-if="$index < (selected.length - 1)">{{ value.name+', ' }}</span>
                                </span>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="deleteFile()" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <ul class="list-group contextMenu" style="display: none;">
                <li ng-click="deleteConfirmation()" class="list-group-item deleteBtn"><i class="fa fa-trash"></i> &nbsp;&nbsp;Delete</li>
                <li ng-click="getVersions()" class="list-group-item versionsBtn"><i class="fa fa-clock-o"></i> &nbsp;&nbsp;Versions</li>
            </ul>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
    <?php if($_SESSION['readOnlyAdmin'] != true){ ?>
        <div class="selectedFilesHidden col-lg-4 col-md-4 col-sm-4">
            <div class="panel" style="border: none; z-index: 999999;">
                <div class="panel-body clickAble openSelectedFiles">
                    <h5>Check Selected Files <span class="label label-danger" ng-cloak>{{ selectedFileForRestoreList.length + selectedFilesForRestoreFromVersions.length }}</span></h5>
                </div>
            </div>
        </div>
    <?php } ?>
    <div class="selectedFiles col-lg-4" style="display: none;">
        <div class="panel">
            <div class="panel-heading clickAble closeSelectedFiles">
                <h5>Selected Files for Restore <span class="label label-danger" ng-cloak>{{ selectedFileForRestoreList.length + selectedFilesForRestoreFromVersions.length }}</span></h5>
                <button ng-if="selectedFileForRestoreList.length > 0 || selectedFilesForRestoreFromVersions.length > 0" class="initiateRestoreBtn btn btn-success btn-small pull-right clickable" style="margin-top: -30px" ng-click="initiateRestore()">Initiate Restore</button>
            </div>
            <div class="panel-body" style="height: 200px; overflow: scroll; overflow-x: hidden;">
                <form>
                    <div class="form-group">
                        <input type="text" class="form-control restorePath" id="restorePath" placeholder="Restore Path">
                    </div>
                    <div class="form-group">
                        <input type="text" class="form-control restoreTimeStamp" id="restoreTimeStamp" placeholder="Restore Time Stamp">
                    </div>
                </form>
                <p class="selectedFileForRestoreList" style="z-index: 9999999999999999;">
                    <a ng-repeat="value in selectedFileForRestoreList track by $index" class="selectedFileLabel">{{ value.name }} <i class="fa fa-times" style="cursor: pointer" ng-click="removeFromSelectedItems($index)"></i></a>
                    <a ng-repeat="value in selectedFilesForRestoreFromVersions track by $index" class="selectedFileLabel">{{ value.name }} <i class="fa fa-times" style="cursor: pointer" ng-click="removeFromSelectedItemsVersions($index)"></i></a>
                </p>
            </div>
        </div>
    </div>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ServerController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.closeSelectedFiles').on('click', function(){
        $('.openSelectedFiles').show();
        $('.selectedFiles').hide();
    });
    $('.openSelectedFiles').on('click', function(){
        $('.openSelectedFiles').hide();
        $('.selectedFiles').show();
    });
    $('#restoreTimeStamp').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        endDate: '+0d',
        todayHighlight: true
    });
</script>