<?php
use Core\Language;
use Helpers\Assets;
use Helpers\Form;
use Helpers\Url; ?>

<div class="container">
    <div class="row">

    </div>
    <br/>
    <div class="row">
        <div class="col-lg-6 col-lg-offset-3">
            <div class="panel panel-default no-box-shadow">
                <div class="panel-heading" style="padding: 30px 30px 10px 30px;">
                    <a><b class="h3"><?=$data['title'];?></b> - <?=$data['passwordReset_message']?></a>
                </div>
                <div class="panel-body">
                    <div  id="status" style="display: none; margin-bottom: 10px;"></div>
                    <?=
                        Form::open(array(
                            'action' => Url::basePath('updatePassword'),
                            'method' => 'post',
                            'class' => 'restPassword',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                    ?>
                        <div class="form-group">
                            <label for="password">Password</label>
                            <input type="password" class="form-control" name="password" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                        </div>
                        <div class="form-group">
                            <label for="rePassword">Re Type Password</label>
                            <input type="password" class="form-control" id="rePassword" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <?=URL::link('login', Language::show('go_backup', 'keywords'))?>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary pull-right submit"><?=Language::show('submit', 'keywords');?></button>
                    <?=
                        Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>