<?php
use \Helpers\Url;
use \Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* search.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 8/6/15
* @time 3:00 PM
* 
*/
?>
<?php
    $searchEnabled = 'none';
    if(Auth::checkCloudPermission('sync')){
        if(Auth::checkUserPermission('admin')){
            $searchEnabled = 'all';
        }else{
            $searchEnabled = 'files';
        }
    }else{
        if(Auth::checkUserPermission('admin')){
            $searchEnabled = 'usersDevices';
        }else{
            $searchEnabled = 'none';
        }
    }
?>
<div class="morphSearchText hide"><?=$searchEnabled;?></div>
<div class="searchEnabled hide"><?php
        if(!empty($_SESSION['search']) && $_SESSION['search'] == 'enabled'){
            echo 'enabled';
        }else{
            echo 'disabled';
        }
        $_SESSION['search'] = '';
    ?></div>
<?php if($searchEnabled != 'none'){ ?>
    <?php if(Auth::checkCloudPermission('serverBackup') == false){ ?>
    <div id="morphsearch" class="morphsearch desktop-only">
        <form class="morphsearch-form" ng-submit="searchThisText(search.text)">
        <?php if(Auth::checkCloudPermission('backup') == false){ ?>
            <input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" type="search" placeholder="<?=BACKUP_SEARCH_MESSAGE?>"/>
        <?php } else{ ?>
            <input id="morphsearch-input" ng-modal="search.text" class="morphsearch-input" type="search" placeholder="<?=SYNC_SEARCH_MESSAGE?>"/>
        <?php } ?>
            <button class="morphsearch-submit" type="submit">Search</button>
        </form>
        <div class="morphsearch-content">
            <div class="dummy-column">
                <a class="status-text">Let me know what do you want me to search for?</a>
                <a class="h4 status-error" style="display: none;"></a>
                <div class="search-results row">
                    <div class="col-lg-12 col-md-6 col-sm-3">
                        <section class="dummy-media-object" style="cursor: auto; padding: 15px;" ng-repeat="value in foundFiles track by $index">
                            <a class="h4">{{ value.fileName }} <span class="h6">, File Path - {{ value.filePath }}</span></a>
                            <a ng-click="searchDownload(value.filePath, value.fileName, value.fileRevisionID)" class="btn btn-success btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Download"><i class="fa fa-download"></i> </a>
                            <a ng-click="searchOpenFolderOption(value.filePath, value.fileName)" class="btn btn-primary btn-small pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Open File Location"" style="margin-right: 10px"><i class="fa fa-folder-open"></i> </a>
                            <p><span ng-bind-html="getHtmlContent(value.content)"></span></p>
                        </section>
                    </div>
                    <div class="col-lg-6" ng-repeat="value in foundUsers track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.userName }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.userName }}"/>
                            <h3>{{ value.userName }}</h3>
                        </a>
                    </div>
                    <div class="col-lg-6" ng-repeat="value in foundDevices track by $index">
                        <a class="dummy-media-object" href="<?=\Helpers\Url::basePath()?>myAccount/{{ value.userName }}">
                            <img class="round" src="<?=Url::basePath('app/templates/default/images/default_profile.jpg')?>" alt="{{ value.devicename }}"/>
                            <h3>
                                <i class="fa fa-desktop"></i> {{ value.deviceName }} of user "{{ value.userName }}"
                            </h3>
                        </a>
                    </div>
                </div>
            </div>
        </div><!-- /morphsearch-content -->
        <span class="morphsearch-close"></span>
    </div><!-- /morphsearch -->
    <?php } ?>
<?php } ?>
