/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('ReportController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'timeAgo', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, timeAgo) {

    timeAgo.settings.fullDateAfterSeconds = 60*60*24;

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = false;
    $scope.overviewSortType = '';
    $scope.sortType = '';

    $scope.current = {};
    $scope.summary = {};
    $scope.statistics = {};
    $scope.overviewJobTime = '';
    $scope.overview = [];
    $scope.skipValue = 0;
    $scope.restoreByDate = [];
    $scope.initialLimit = 500;
    $scope.longBackup = [];
    $scope.currentBackup = [];
    $scope.noBackup = [];
    $scope.storageUtilized = [];
    $scope.storageUtilizedByPG = [];
    $scope.failedBackup = [];
    $scope.failedBackupByUserOrDevice = [];
    $scope.dailyUserBackupOverview = [];
    $scope.userBackupHistory = [];
    $scope.userDeviceHistory = [];

    $scope.search = {};
    var currentDate = new Date();
    $scope.search.to = getFormattedDate(currentDate);

    currentDate.setDate(currentDate.getDate() - 30);
    $scope.search.from = getFormattedDate(currentDate);

    function getFormattedDate(today){
        var dd = today.getDate();
        var mm = today.getMonth()+1;

        var yyyy = today.getFullYear();
        if(dd<10){
            dd='0'+dd
        }
        if(mm<10){
            mm='0'+mm
        }
        return mm+'/'+dd+'/'+yyyy;
    }

    $scope.updateStatistics = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/statistics',
            data: {secret: '',csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            $scope.statistics = jData.statistics;
            $scope.$apply();
            $('.widget a').removeClass('hide');
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateServerBackupDetails = function(){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/statistics/serverBackup',
            data: {secret: '',csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            $scope.statistics = jData.statistics;
            $scope.$apply();
            $('.widget a').removeClass('hide');
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateOverview = function(userName, skipValue, deviceName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/overview',
            data: {skipValue: $scope.skipValue,csrf_token: $('.token').html(), userName: userName, deviceName: deviceName},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('.overviewListTable').show();
                $('.loading').hide();
                if(jData.overview.length > 0){
                    if(skipValue == 0){
                        $scope.overview = jData.overview;
                    }else{
                        $scope.overview = $scope.overview.concat(jData.overview);
                    }
                    $scope.overviewJobTime = jData.overViewJobTime;
                    $('.overviewJobTime').show();
                    if(userName == 'all' && userName != ''){
                        $scope.skipValue = skipValue+1;
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                    $scope.$apply();
                    if($scope.overview.length < $scope.initialLimit && userName == 'all'){
                        $scope.updateOverview('all', $scope.skipValue, 'all');
                    }

                }else{
                    $('.loading').hide();
                    $('.loadMore').hide();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchUserInOverView = function(userName){
        $('.loading').show();
        $('.loading').html('Loading...');
        if(userName == "all"){
            $scope.skipValue = 0;
            $scope.$apply()
        }
        var deviceName = $('.searchDeviceName').val();
        $scope.updateOverview(userName, 0, deviceName)
    };

    $scope.updateRestoreHistory = function(from, to, userName, deviceName, skipValue){
        if(userName.length <= 0 || userName == 'all'){
            userName = $('.searchUsername').val();
        }

        if(userName == "? undefined:undefined ?"){
            userName = "all"
        }

        if(deviceName.length <= 0 || deviceName == 'all'){
            deviceName = $('.searchDeviceName').val();
        }

        $scope.skipValue = skipValue;
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/restoreHistory',
            data: {skipValue: skipValue,csrf_token: $('.token').html(), to: to, from: from, userName: userName, deviceName:deviceName},
            type: 'POST'
        }).done(function(data){
            console.log(data);
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue == 0 && jData.restoreByDate == null){
                    $('.restoreError').show();
                    $('.restoreHistory').hide();
                }else{
                    $('.restoreError').hide();
                    $('.restoreHistory').show();
                }
                if($scope.skipValue == 0){
                    $scope.restoreByDate = jData.restoreByDate;
                }else{
                    if(jData.restoreByDate != null){
                        $scope.restoreByDate = $scope.restoreByDate.concat(jData.restoreByDate);
                    }
                }
                $scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.restoreByDate != null && $scope.restoreByDate.length < $scope.initialLimit){
                    $scope.updateRestoreHistory(from, to, userName, deviceName, $scope.skipValue);
                }else{
                    if(jData.restoreByDate != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
            $scope.$apply();
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateSyncCloudUsageDetails = function(from, to){
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/updateSyncCloudUsageDetails',
            data: {csrf_token: $('.token').html(), to: to, from: from},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.syncCloudUsageDetails == null){
                    $('.syncCLoudUsageError').show();
                    $('.syncCLoudUsageWithDetails').hide();
                }else{
                    $('.syncCLoudUsageError').hide();
                    $('.syncCLoudUsageWithDetails').show();
                }
                $scope.syncCloudUsageDetails = jData.syncCloudUsageDetails;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateLongBackup = function(skipValue){

        $scope.skipValue = skipValue;

        $.ajax({
            url: $scope.BASE_FOLDER+'/report/longBackup',
            data: {skipValue: skipValue, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){

            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue == 0 && jData.longBackup == null){
                    $('.longBackupError').show();
                    $('.longBackup').hide();
                }else{
                    $('.longBackupError').hide();
                    $('.longBackup').show();
                }
                if($scope.skipValue == 0){
                    $scope.longBackup = jData.longBackup;
                }else{
                    if(jData.longBackup != null){
                        $scope.longBackup = $scope.longBackup.concat(jData.longBackup);
                    }
                }
                $scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.longBackup != null && $scope.longBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.longBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateCurrentBackup = function(skipValue){

        $scope.skipValue = skipValue;

        $.ajax({
            url: $scope.BASE_FOLDER+'/report/currentBackup',
            data: {skipValue: skipValue, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue == 0 && jData.currentBackup == null){
                    $('.currentBackupError').show();
                    $('.currentBackup').hide();
                }else{
                    $('.currentBackupError').hide();
                    $('.currentBackup').show();
                }
                if($scope.skipValue == 0){
                    $scope.currentBackup = jData.currentBackup;
                }else{
                    if(jData.currentBackup != null){
                        $scope.currentBackup = $scope.currentBackup.concat(jData.currentBackup);
                    }
                }
                $scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.currentBackup != null && $scope.currentBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.currentBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateNoBackup = function(skipValue, numberOfDays){

        if (numberOfDays <= 0){
            toastr.error("Number of Days should be greater than 0", 'Fail!!!', {allowHtml: true});
        }

        $('.noBackupError').hide();
        $scope.skipValue = skipValue;

        $.ajax({
            url: $scope.BASE_FOLDER+'/report/noBackup',
            data: {skipValue: skipValue, numberOfDays: numberOfDays, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue == 0 && jData.noBackup == null){
                    $('.noBackupError').show();
                    $('.noBackup').hide();
                }else{
                    $('.noBackupError').hide();
                    $('.noBackup').show();
                }
                if($scope.skipValue == 0){
                    $scope.noBackup = jData.noBackup;
                }else{
                    if(jData.noBackup != null){
                        $scope.noBackup = $scope.noBackup.concat(jData.noBackup);
                    }
                }
                $scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.noBackup != null && $scope.noBackup.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.noBackup != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateStorageUtilized = function(userName, deviceName, skipValue){
        $('.storageUtilizedError').hide();
        $scope.current.userName = userName;
        $scope.current.deviceName = deviceName;
        $scope.skipValue = skipValue;
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/storageUtilized',
            data: {skipValue: skipValue, csrf_token: $('.token').html(), userName: userName, deviceName: deviceName},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(skipValue == 0 && jData.storageUtilized == null){
                    $('.storageUtilizedError').show();
                    $('.storageUtilized').hide();
                }else{
                    $('.storageUtilizedError').hide();
                    $('.storageUtilized').show();
                }
                if($scope.skipValue == 0){
                    $scope.storageUtilized = jData.storageUtilized;
                }else{
                    if(jData.storageUtilized != null){
                        $scope.storageUtilized = $scope.storageUtilized.concat(jData.storageUtilized);
                    }
                }
                $scope.skipValue = parseInt(skipValue)+1;
                $scope.$apply();
                if(jData.storageUtilized != null && $scope.storageUtilized.length < $scope.initialLimit){
                    //$scope.updateLongBackup($scope.skipValue);
                }else{
                    if(jData.storageUtilized != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateStorageUtilizedByPG = function(){
        $('.storageUtilizedByPGError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/storageUtilizedByPG',
            data: {skipValue: '', csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.storageUtilizedByPG == null){
                    $('.storageUtilizedByPGError').show();
                    $('.storageUtilizedByPG').hide();
                }else{
                    $('.storageUtilizedByPGError').hide();
                    $('.storageUtilizedByPG').show();
                }
                $scope.storageUtilizedByPG = jData.storageUtilizedByPG;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFailedBackupByDate = function(from, to, skipValue){
        var userName = $('.searchUsername').val();
        var deviceName = $('.searchDeviceName').val();
        $('.failedBackupError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/failedBackup',
            data: {skipValue: skipValue, from: from, to: to,userName: userName, deviceName: deviceName, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.failedBackup.length <= 0){
                    $('.failedBackupError').show();
                    $('.failedBackup').hide();
                }else{
                    $('.failedBackupError').hide();
                    $('.failedBackup').show();
                }
                if(skipValue == 0){
                    $scope.failedBackup = jData.failedBackup;
                }else{
                    $scope.failedBackup = $scope.failedBackup.concat(jData.failedBackup);
                    if(jData.failedBackup.length > 0){
                        $scope.skipValue = skipValue+1;
                        $scope.updateFailedBackupByDate(from, to, skipValue)
                    }
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFailedBackupByUserOrDevice = function(userName, deviceName, skipValue){
        $('.failedBackupByUserOrDeviceError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/failedBackup',
            data: {skipValue: skipValue, userName: userName, deviceName: deviceName, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.failedBackup.length <= 0){
                    $('.failedBackupByUserOrDeviceError').show();
                    $('.failedBackupByUserOrDevice').hide();
                }else{
                    $('.failedBackupByUserOrDeviceError').hide();
                    $('.failedBackupByUserOrDevice').show();
                }
                if(skipValue == 0){
                    $scope.failedBackupByUserOrDevice = jData.failedBackup;
                }else{
                    $scope.failedBackupByUserOrDevice = $scope.failedBackupByUserOrDevice.concat(jData.failedBackup);
                    if(jData.failedBackup.length > 0){
                        $scope.skipValue = skipValue+1;
                        $scope.updateFailedBackupByUserOrDevice(from, to, skipValue)
                    }
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserDeviceHistory = function(userName){
        $('.userDeviceHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userDeviceHistory',
            data: {userName: userName, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.userDeviceHistory == null){
                    $('.userDeviceHistoryError').show();
                    $('.userDeviceHistory').hide();
                }else{
                    $('.userDeviceHistoryError').hide();
                    $('.userDeviceHistory').show();
                }
                $scope.userDeviceHistory = jData.userDeviceHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function showDetailsForSelectedRow() {
        $("td[details=9]").find("p").hide();
        $("#SomeTable").click(function(event) {
            event.stopPropagation();
            var $target = $(event.target);
            if ( $target.closest("td").attr("details") > 1 ) {
                $target.slideUp();
            } else {
                $target.closest("tr").next().find("p").slideToggle();
            }
        });
    }

    $scope.updateUserBackupHistory = function(userName, from, to){
        var deviceName = $('.searchDeviceName').val();
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userBackupHistory',
            data: {userName: userName, from: from, to: to, deviceName: deviceName, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.userBackupHistory == null){
                    $('.userBackupHistoryError').show();
                    $('.userBackupHistory').hide();
                }else{
                    $('.userBackupHistoryError').hide();
                    $('.userBackupHistory').show();
                }
                $scope.userBackupHistory = jData.userBackupHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDailyUserBackupOverview = function(userName, from, to){
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        var deviceName = $('.searchDeviceName').val()
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/getDailyUserBackupOverview',
            data: {userName: userName,deviceName: deviceName, from: from, to: to, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.dailyUserBackupOverview.length <=0){
                    $('.dailyUserBackupOverviewError').show();
                    $('.dailyUserBackupOverview').hide();
                }else{
                    $('.dailyUserBackupOverviewError').hide();
                    $('.dailyUserBackupOverview').show();
                }
                $scope.dailyUserBackupOverview = jData.dailyUserBackupOverview;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadDailyUserBackupOverview = function(userName, from, to){
        $('.userBackupHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/downloadDailyUserBackupOverview',
            data: {userName: userName, from: from, to: to, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = $scope.BASE_FOLDER+'/report/downloadDailyUserBackupOverviewExcel';
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateStorageTrend = function(from, to){
        var source = '';
        if($scope.currentPage != 'dashboard' && $scope.currentPage != 'serverBackup'){
            $('.storageTrend').html();
            $('.storageTrend').html('<canvas id="myChart" width="600px" height= "200px"><canvas>');
        }else{
            source = 'dashboard';
        }
        $.ajax({
            type: "POST",
            url: $scope.BASE_FOLDER+'/report/storageTrend',
            data: { from : from, to : to, source: source}
        }).success(function(response){
            $('.loading').hide();
            var jData = jQuery.parseJSON(response);
            if(jData.result == 'fail') {
                if($scope.currentPage == 'dashboard' || $scope.currentPage == 'serverBackup'){
                    $('.storageTrendPanel').html('<div class="text-center" style="height:260px; width:545px"><br/><br/><br/><br/><br/>There was no recent activity :)</div>');
                }
                $('#myChart').addClass('hide');
                if(jData.msg.length > 0){
                    toastr.info(jData.msg, 'Information!!!', {allowHtml: true});
                }else if(from.length > 0 && from.to > 0){
                    toastr.info('There was no data found for the specified time period', 'Information!!!', {allowHtml: true});
                }else{
                    toastr.info('There was no activity from past 30 days', 'Information!!!', {allowHtml: true});
                }
            }else {
                $('#myChart').removeClass('hide');
                var data = {
                    labels: [],
                    datasets: []
                };
                for (var key in jData) {
                    var label = key;
                    var seriesData = [];
                    var color   = getRandomColor();
                    jData[key].forEach(function (item) {
                        if ($.inArray(item.date, data.labels) == -1) {
                            data.labels.push(item.date);
                        }
                        seriesData.push(item.size);
                    });
                    data.datasets.push(
                        {
                            label: label,
                            fillColor: "rgba(236,102,33,0)",
                            strokeColor: color,
                            pointColor: color,
                            pointStrokeColor: "#fff",
                            pointHighlightFill: "#fff",
                            pointHighlightStroke: "rgba(238,84,33,1)",
                            data: seriesData
                        }
                    );
                }
                Chart.defaults.global.responsive = true;
                Chart.defaults.global.tooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                Chart.defaults.global.multiTooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                var ctx = document.getElementById("myChart").getContext("2d");
                var myLineChart = new Chart(ctx).Line(data);
                myLineChart.removeData();
            }
        }).error(function(data){
        toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateBlobTrend = function(from, to){
        $('.blobTrend').html();
        $('.blobTrend').html('<canvas id="myChart" width="600px" height= "200px"><canvas>');
        $.ajax({
            type: "POST",
            url: $scope.BASE_FOLDER+'/report/blobTrend',
            data: { from : from, to : to }
        }).success(function(response){
                $('.loading').hide();
                var jData = jQuery.parseJSON(response);
                if(jData.result == 'fail') {
                    $('#myChart').addClass('hide');
                    if(jData.msg.length > 0){
                        toastr.info(jData.msg, 'Information!!!', {allowHtml: true});
                    }else if(from.length > 0 && from.to > 0){
                        toastr.info('There was no data found for the specified time period', 'Information!!!', {allowHtml: true});
                    }else{
                        toastr.info('There was no activity from past 30 days', 'Information!!!', {allowHtml: true});
                    }
                }else {
                    $('#myChart').removeClass('hide');
                    var data = {
                        labels: [],
                        datasets: []
                    };
                    for (var key in jData) {
                        var label = key;
                        var seriesData = [];
                        var color   = getRandomColor();
                        jData[key].forEach(function (item) {
                            if ($.inArray(item.date, data.labels) == -1) {
                                data.labels.push(item.date);
                            }
                            seriesData.push(item.size);
                        });
                        data.datasets.push(
                            {
                                label: label,
                                fillColor: "rgba(236,102,33,0)",
                                strokeColor: color,
                                pointColor: color,
                                pointStrokeColor: "#fff",
                                pointHighlightFill: "#fff",
                                pointHighlightStroke: "rgba(238,84,33,1)",
                                data: seriesData
                            }
                        );
                    }
                    Chart.defaults.global.responsive = true;
                    Chart.defaults.global.tooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    Chart.defaults.global.multiTooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    var ctx = document.getElementById("myChart").getContext("2d");
                    var myLineChart = new Chart(ctx).Line(data);
                    myLineChart.removeData();
                }
            }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateBackupTrend = function(from, to){
        $('.blobTrend').html();
        $('.blobTrend').html('<canvas id="myChart" width="600px" height= "200px"><canvas>');
        $.ajax({
            type: "POST",
            url: $scope.BASE_FOLDER+'/report/backupTrend',
            data: { from : from, to : to }
        }).success(function(response){
                $('.loading').hide();
                var jData = jQuery.parseJSON(response);
                if(jData.result == 'fail') {
                    $('#myChart').addClass('hide');
                    if(jData.msg.length > 0){
                        toastr.info(jData.msg, 'Information!!!', {allowHtml: true});
                    }else if(from.length > 0 && from.to > 0){
                        toastr.info('There was no data found for the specified time period', 'Information!!!', {allowHtml: true});
                    }else{
                        toastr.info('There was no activity from past 30 days', 'Information!!!', {allowHtml: true});
                    }
                }else {
                    $('#myChart').removeClass('hide');
                    var data = {
                        labels: [],
                        datasets: []
                    };
                    for (var key in jData) {
                        var label = key;
                        var seriesData = [];
                        var color   = getRandomColor();
                        jData[key].forEach(function (item) {
                            if ($.inArray(item.date, data.labels) == -1) {
                                data.labels.push(item.date);
                            }
                            seriesData.push(item.size);
                        });
                        data.datasets.push(
                            {
                                label: label,
                                fillColor: "rgba(236,102,33,0)",
                                strokeColor: color,
                                pointColor: color,
                                pointStrokeColor: "#fff",
                                pointHighlightFill: "#fff",
                                pointHighlightStroke: "rgba(238,84,33,1)",
                                data: seriesData
                            }
                        );
                    }
                    Chart.defaults.global.responsive = true;
                    Chart.defaults.global.tooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    Chart.defaults.global.multiTooltipTemplate = "<%= datasetLabel %> - <%= value %>";
                    var ctx = document.getElementById("myChart").getContext("2d");
                    var myLineChart = new Chart(ctx).Line(data);
                    myLineChart.removeData();
                }
            }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function getRandomColor() {
        var letters = '0123456789ABCDEF'.split('');
        var color = '#';
        for (var i = 0; i < 6; i++ ) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }



    $scope.updateDeviceUserHistory = function(deviceName){
        $('.deviceUserHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/deviceUserHistory',
            data: {deviceName: deviceName, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.deviceUserHistory == null){
                    $('.deviceUserHistoryError').show();
                    $('.deviceUserHistory').hide();
                }else{
                    $('.deviceUserHistoryError').hide();
                    $('.deviceUserHistory').show();
                }
                $scope.deviceUserHistory = jData.deviceUserHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateDeviceBackupHistory = function(deviceName, from, to){
        $('.deviceBackupHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/deviceBackupHistory',
            data: {deviceName: deviceName, from: from, to: to, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.deviceBackupHistory == null){
                    $('.deviceBackupHistoryError').show();
                    $('.deviceBackupHistory').hide();
                }else{
                    $('.deviceBackupHistoryError').hide();
                    $('.deviceBackupHistory').show();
                }
                $scope.deviceBackupHistory = jData.deviceBackupHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getLastBackupDetails = function(deviceName, userName){
        $('.lastBackupDetailsError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/lastBackupDetails',
            data: {deviceName: deviceName, userName: userName, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.lastBackupDetails == null){
                    $('.lastBackupDetailsError').show();
                    $('.lastBackupDetails').hide();
                }else{
                    $('.lastBackupDetailsError').hide();
                    $('.lastBackupDetails').show();
                }
                $scope.lastBackupDetails = jData.lastBackupDetails;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateAlertHistory = function(userName, deviceName, from, to){
        $('.alertHistoryError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/alertHistory',
            data: {deviceName: deviceName, userName: userName, from: from, to: to, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.alertHistory == null){
                    $('.alertHistoryError').show();
                    $('.alertHistory').hide();
                }else{
                    $('.alertHistoryError').hide();
                    $('.alertHistory').show();
                }
                $scope.alertHistory = jData.alertHistory;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserMigration = function(skipValue){
        $('.userMigrationError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/userMigration',
            data: {skipValue: skipValue, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.userMigration == null && $scope.userMigration.length < 0){
                    $('.userMigrationError').show();
                    $('.userMigration').hide();
                }else{
                    $('.userMigrationError').hide();
                    $('.userMigration').show();
                }
                if(jData.userMigration != null){
                    if(skipValue == 0){
                        $scope.userMigration = jData.userMigration;
                    }else{
                        $scope.userMigration = $scope.userMigration.concat(jData.userMigration);
                    }
                }
                if(jData.userMigration != null && $scope.userMigration.length > 1){
                    $scope.skipValue = skipValue+1;
                    $scope.updateUserMigration($scope.skipValue);
                }else{
                    if(jData.userMigration != null){
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
                    }
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.loadMore = function(skipValue, type){
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        if(type == 'overview'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateOverview('all', skipValue, 'all');
        }

        if(type == 'restoreHistory'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateRestoreHistory($scope.current.from, $scope.current.to, $scope.current.userName, $scope.current.deviceName, skipValue);
        }

        if(type == 'restoreHistory'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateSyncCloudUsageDetails($scope.current.from, $scope.current.to);
        }

        if(type == 'longBackup'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateLongBackup($scope.skipValue);
        }

        if(type == 'currentBackup'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateCurrentBackup($scope.skipValue);
        }

        if(type == 'noBackup'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateNoBackup($scope.skipValue, 7);
        }

        if(type == 'storageUtilized'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateStorageUtilized($scope.current.userName, $scope.current.deviceName, $scope.skipValue);
        }

        if(type == 'storageUtilizedByPG'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateStorageUtilizedByPG();
        }

        if(type == 'failedBackupByDate'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateFailedBackupByDate('', '', $scope.skipValue);
        }

        if(type == 'failedBackupByUserOrDevice'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateFailedBackupByUserOrDevice('', '', $scope.skipValue);
        }

        if(type == 'userMigration'){
            $scope.initialLimit = $scope.initialLimit+500;
            $scope.updateUserMigration($scope.skipValue);
        }

    };

    $scope.updateSyncCLoudUsage = function(skipValue){
        $('.syncCLoudUsageError').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/report/syncCLoudUsage',
            data: {skipValue: skipValue, csrf_token: $('.token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.syncCLoudUsage == null && $scope.syncCLoudUsage.length < 0){
                    $('.syncCLoudUsageError').show();
                    $('.syncCLoudUsage').hide();
                }else{
                    $('.syncCLoudUsageError').hide();
                    $('.syncCLoudUsage').show();
                }
                $scope.syncCLoudUsage = jData.syncCLoudUsage;
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.redirectTo = function(url){
        window.location = url;
    };

    $scope.redirectToDownload = function(url, to, from){
        window.location = url+'?toDate='+encodeURIComponent(to)+'&fromDate='+encodeURIComponent(from);
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        var fromDate = new Date();
        var toDate = new Date();
        fromDate = fromDate.setDate(fromDate.getDate() - 6);
        toDate = toDate.setDate(toDate.getDate());
        if($scope.currentPage == 'dashboard'){
            $scope.updateStatistics();
            $scope.updateCurrentBackup(0);
            // $scope.updateStorageTrend(fromDate, toDate);
        }
        if($scope.currentPage == 'serverBackup'){
            $scope.updateServerBackupDetails();
            $scope.updateStorageTrend(fromDate, toDate);
        }
        if($scope.currentPage == 'statistics'){
            $scope.updateStatistics();
        }
        if($scope.currentPage == 'overview'){
            $scope.updateOverview('all', 0);
        }
        if($scope.currentPage == 'longBackup'){
            $scope.updateLongBackup(0);
        }
        if($scope.currentPage == 'currentBackup'){
            $scope.updateCurrentBackup(0);
        }
        if($scope.currentPage == 'noBackup'){
            $scope.updateNoBackup(0, 7);
        }
        if($scope.currentPage == 'storageUtilized'){
            $scope.updateStorageUtilized('', '', 0);
        }
        if($scope.currentPage == 'storageUtilizedByPG'){
            $scope.updateStorageUtilizedByPG();
        }
        if($scope.currentPage == 'failedBackupByUserOrDevice'){
            $scope.updateFailedBackupByUserOrDevice('', '', 0);
        }
        if($scope.currentPage == 'failedBackupByDate'){
            $scope.updateFailedBackupByDate('', '', 0);
        }
        if($scope.currentPage == 'storageTrend'){
            $scope.updateStorageTrend('', '');
        }
        if($scope.currentPage == 'blobTrend'){
            $scope.updateBlobTrend('', '');
        }
        if($scope.currentPage == 'backupTrend'){
            $scope.updateBackupTrend('', '');
        }
        if($scope.currentPage == 'userDeviceHistory'){
            $scope.updateUserDeviceHistory('');
        }
        if($scope.currentPage == 'deviceUserHistory'){
            $scope.updateDeviceUserHistory('');
        }
        if($scope.currentPage == 'userMigration'){
            $scope.updateUserMigration(0);
        }
        if($scope.currentPage == 'syncCLoudUsage'){
            $scope.updateSyncCLoudUsage(0);
            $scope.updateSyncCloudUsageDetails($('#from').val(), $('#to').val());
        }

        var error = $('.resultError').html();
        if(error){
            if(error.length > 0){
                toastr.error(error, 'Fail');
            }
        }

    });

}]);