<?php
namespace Models;

use Core\Model;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Server extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Server Model was called', 'info');
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @return array
     */
    public function getDeviceDetails($headers){
        $url = $this->api->getUrl('getDeviceDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below mentioned method will
     * save a container
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveContainer($headers, $data){
        $url = $this->api->getUrl('saveContainer');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below mentioned method will
     * save a container
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveEditedContainer($headers, $data){
        $url = $this->api->getUrl('saveEditedContainer');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below mentioned method will
     * save a container
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function removeContainer($headers, $data){
        $url = $this->api->getUrl('removeContainer');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below mentioned method will
     * save a container
     *
     * @param $headers
     * @return array
     */
    public function getAllContainers($headers){
        $url = $this->api->getUrl('getContainers');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below mentioned method will
     * save a container
     *
     * @param $headers
     * @return array
     */
    public function getListOfServerJobs($headers){
        $url = $this->api->getUrl('listOfServerJobs');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function searchInDevices($headers){
        $url = $this->api->getUrl('searchDevices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function getAllDevicesWithUserName($headers, $userName){
        $url = $this->api->getUrl('backupDevices', array('userName' => $userName));
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllDevices($headers){
        $url = $this->api->getUrl('listOfDevices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFiles($headers){
        $url = $this->api->getUrl('containerFiles');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
}