<?php
namespace Helpers\Paraview;
/**
 * Created by PhpStorm.
 * User: parablu-dev
 * Developer: Prashanth Kumar B
 * Date: 3/2/15
 * Time: 10:34 AM
 */

class DocReader {

    /**
     * @var String This is the path to the file that should be read
     * @since 1.0
     */
    var $docPath = "";
    /**
     * @var String This is where the zipped contents will be extracted to to process
     * @since 1.0
     */
    var $tempDir = "";
    /**
     *
     * @var String This is the html data that is returned from this class
     * @since 1.0
     */
    var $output = array();
    /**
     *
     * @var String This is where the color of the body is saved
     * @since 1.0
     */
    var $bodyColor = "";
    /**
     * @var Int This is the maximum width of an image after the process
     * @since 1.0
     * @update 1.2
     */
    var $image_max_width = 0;
    /**
     * @var String The path to where the content is extracted
     * @since 1.0
     */
    var $content_folder = "";
    /**
     * @var String The current Status of the class
     * @since 1.0
     */
    var $status = "";
    /**
     * @var String The path to where the media files of the document should be extracted
     * @since 1.0
     */
    var $mediaDir = "";
    /**
     * @var String The value of this variable will be prefixed to the path of the image. This class will create a folder 2 levels up, inside an 'upload' folder and this value should go to there.
     * @since 1.0
     */
    var $imagePathPrefix = "";
    /**
     * @var Float The time the scipt took to complete the file parsing
     * @since 1.0
     */
    var $time = 0;
    /**
     * @var Array This contains the relationships of different elements inside the word document and is used to link to the correct image.
     * @since 1.1
     */
    var $rels = array();
    /**
     * @val String The error number generated and the meaning of the error
     * @since 1.0
     */
    var $error = NULL;
    /**
     * @val String This will contain the closing tag of a paragraph level opened tag that can't be specified explicitly
     * @since 1.1
     */
    var $tagclosep = "";
    /**
     * @val String This will contain the closing tag of a text opened tag that can't be specified explicitly
     * @since 1.1
     */
    var $tagcloset = "";

    /**
     * @var String The First path of the tag currently working on
     * @since 1.0
     */
    var $openedTag = "";

    /**
     * @var String The last path of the tag currently working on
     * @since 1.0
     */
    var $closedTag = "";

    /**
     * @var String This element contains the style of the page
     * @since 1.0
     */
    var $pageStyle = "";

    /**
     * @var String This element contains the style of the content inside the page
     * @since 1.0
     */
    var $contentStyle = "";

    /**
     * @var String this element contains the style of the header and the footer
     * @since 1.0
     */
    var $pageHeaderStyle = "";

    /**
     * @val Bool SWhould a thumbnail be created as well as to keep the original image in the folder
     * @since 1.3
     */
    var $keepOriginalImage = false;

    /**
     * @val Bool The Entire Data that has been extracted stored in an array
     * @since 1.3
     */
    var $contentsInArray = array('');


    /**
     * This function start the timer of this script
     *
     * @global Float $timeStart The time the function started, used to calculate script proccessing time
     * @return Bool True when the timer have started
     * @since 1.0
     */
    function timer_start() {
        global $timestart;
        $mtime = explode(' ', microtime() );
        $mtime = $mtime[1] + $mtime[0];
        $timestart = $mtime;
        return true;
    }
    /**
     * This function calculates the difference between when the timer_start was called and the current time
     *
     * @global Float $timestart The time the timer have started
     * @global Float $timeend The time the timer is stopped
     * @param Int $display Should the result be displayed or returned
     * @param Int $precision The amount of decimals to return (after the comma)
     * @return Float Containing the Time since the timer start was called
     * @since 1.0
     */
    function timer_stop($display = 0, $precision = 3) { //if called like timer_stop(1), will echo $timetotal
        global $timestart, $timeend;
        $mtime = microtime();
        $mtime = explode(' ',$mtime);
        $mtime = $mtime[1] + $mtime[0];
        $timeend = $mtime;
        $timetotal = $timeend-$timestart;
        $r = number_format($timetotal, $precision);
        if ( $display )
            echo $r;
        return $r;
    }
    /**
     * This function will set the status to Ready when the class is called. The Constructor Method.
     * @since 1.0
     */
    function __construct(){
        $this->timer_start();
        $this->status = "Ready";
        return true;
    }
    /**
     * This function call the Constructor Method
     * @return Bool True when ready
     * @since 1.0
     */
    function docReader(){
        return __construct();
    }
    /**
     * This function will initialize the process as well as handle the process automatically.
     * This requires that the vars be set to start
     * @return Bool True when successfully completed
     * @since 1.0
     * @modified 1.2.3
     */
    function Init(){
        if($this->testInput()==false){
            $this->time = $this->timer_stop(0);
            $this->error = "11. Not enough information provided to parse the file.";
            return false;
        }
        if($this->UnZipdoc()==false){
            $this->time = $this->timer_stop(0);
            $this->error = "12. The file's contents could not be extracted to use.";
            return false;
        }
        if($this->extractRelXML()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "13. The file data could not be found or read.";
            return false;
        }
        if($this->extractMedia()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "14. The Media could not be found.";
            return false;
        }
        if($this->extractXML()==false){
            $this->DeleteTemps();
            $this->time = $this->timer_stop(0);
            $this->error = "15. The file data could not be found or read.";
            return false;
        }
        if($this->DeleteTemps()==false){
            $this->time = $this->timer_stop(0);
            $this->error = "16. The temporary files created during the process could not be deleted.
                The contents, however, might still have been extracted.";
            return false;
        }
        $this->time = $this->timer_stop(0);
        return true;
    }
    /**
     * This function make sure that the script have everything it needs to continue
     * @return Bool True if everything is ready for script execution
     * @since 1.0
     */
    function testInput(){
        if(!empty($this->docPath) && $this->status == "Ready" ){
            $this->status = "Starting...";
            return true;
        } else {
            return false;
        }
    }
    /**
     * This function handles the extracting of the zipped contents to the temp folder
     * @return Bool True on success
     * @since 1.0
     * @modified 1.2.3
     */
    function UnZipdoc(){
        require("zipper.php");
        $targetDir = $this->getUniqueDir();
        $this->tempDir = $targetDir;
        $baseDir = "";
        $maintainStructure = true;
        $unzip = new Zipper($this->docPath);
        $unzip->unzipAll($targetDir, $baseDir, $maintainStructure);
        unset($unzip);
        if(is_dir($this->tempDir."/word")){
            return true;
        }
        return false;
    }
    /**
     * This function will get a unique directory for the temporary files
     * @return string The first unique directory the function have found
     * @since 1.0
     */
    function getUniqueDir(){
        $targetDir = "./docTempFolder";
        if(!is_dir($targetDir)){
            return $targetDir;
        }
        $i = 1;
        while(is_dir($targetDir.$i)){
            $i++;
        }
        $i-1;
        return $targetDir.$i;
    }
    /**
     * This function handles the extraction of the XML building the Rels array
     * @return Bool True on success
     * @since 1.1
     * @modified 1.2.3
     */
    function extractRelXML(){
        $xmlFile = $this->tempDir."/word/_rels/document.xml.rels";
        $xml = file_get_contents($xmlFile);
        if($xml == false){
            return false;
        }
        $xml = mb_convert_encoding($xml, 'UTF-8', mb_detect_encoding($xml));
        $parser = xml_parser_create('UTF-8');
        $data = array();
        xml_parse_into_struct($parser, $xml, $data);
        foreach($data as $value){
            if($value['tag']=="RELATIONSHIP"){
                //it is an relationship tag, get the ID attr as well as the TARGET and (if set, the targetmode)set into var.
                if(isset($value['attributes']['TARGETMODE'])){
                    $this->rels[$value['attributes']['ID']] = array(0 => $value['attributes']['TARGET'], 3=> $value['attributes']['TARGETMODE']);
                } else {
                    $this->rels[$value['attributes']['ID']] = array(0 => $value['attributes']['TARGET']);
                }
            }
        }
        return true;
    }
    /**
     * This function handles the extraction of the Media
     * @return Bool True on success
     * @since 1.1
     * @modified 1.2.3
     */
    function extractMedia(){
        $wordFolder = $this->tempDir."/word/";
        if(!is_dir($wordFolder."media")){
            return true;
            //there are no images to extract
        }
        $this->getMediaFolder();
        $i = false;
        foreach($this->rels as $key => $value){
            if(strtolower(pathinfo($value[0],PATHINFO_EXTENSION))=="png" || strtolower(pathinfo($value[0],PATHINFO_EXTENSION))=="gif" || strtolower(pathinfo($value[0],PATHINFO_EXTENSION))=="jpg"
                || strtolower(pathinfo($value[0],PATHINFO_EXTENSION))=="jpeg"){
                //this really is an image that we are working with
                $fileType = strtolower(pathinfo($value[0],PATHINFO_EXTENSION));
                //set the file type so that the correct image creation function can be called
                if(is_file($wordFolder.$value[0])){
                    if($this->keepOriginalImage == true){
                        $image = $this->processImage($wordFolder.$value[0], $this->image_max_width);
                        $imageorr = $this->processImage($wordFolder.$value[0]);
                    } else {
                        $image = $this->processImage($wordFolder.$value[0], $this->image_max_width);
                        $imageorr = false;
                    }
                    if($image){
                        $i = true;//this have been resourceful, do not return false
                        //the image was successfully created, now write to file
                        $filename = pathinfo($value[0],PATHINFO_BASENAME);
                        if($fileType=="png"){
                            if(imagePng($image,$this->mediaDir."/".$filename,0,PNG_NO_FILTER)){
                                imagedestroy($image);
                                $this->rels[$key][1] = $this->mediaDir."/".$filename;
                            }
                        } elseif($fileType=="gif"){
                            if(imageGif($image,$this->mediaDir."/".$filename,0)){
                                imagedestroy($image);
                                $this->rels[$key][1] = $this->mediaDir."/".$filename;
                            }
                        } else {
                            if(imageJpeg($image,$this->mediaDir."/".$filename,100)){
                                imagedestroy($image);
                                $this->rels[$key][1] = $this->mediaDir."/".$filename;
                            }
                        }
                    }
                    if($imageorr){
                        $i = true;//this have been resourceful, do not return false
                        //the image was successfully created, now write to file
                        $pathinfo = pathinfo($value[0]);
                        $filename = $pathinfo['filename']."_big.".$pathinfo['extension'];
                        if($fileType=="png"){
                            if(imagePng($imageorr,$this->mediaDir."/".$filename,0,PNG_NO_FILTER)){
                                imagedestroy($imageorr);
                                $this->rels[$key][2] = $this->mediaDir."/".$filename;
                            }
                        } elseif($fileType=="gif"){
                            if(imageGif($imageorr,$this->mediaDir."/".$filename,0)){
                                imagedestroy($imageorr);
                                $this->rels[$key][2] = $this->mediaDir."/".$filename;
                            }
                        } else {
                            if(imageJpeg($imageorr,$this->mediaDir."/".$filename,100)){
                                imagedestroy($imageorr);
                                $this->rels[$key][2] = $this->mediaDir."/".$filename;
                            }
                        }
                    }
                }
            }
        }
        return $i;
    }
    /**
     * This function creates the folder that will contain the media after the move
     * @return Bool True on success
     * @since 1.0
     */
    function getMediaFolder(){
        if(empty($this->content_folder)){
            $mediaFolder = pathinfo($this->docPath,PATHINFO_BASENAME);
            $ext = pathinfo($this->docPath,PATHINFO_EXTENSION);
            $MediaFolder = strtolower(str_replace(".".$ext,"",str_replace(" ","-",$mediaFolder)));
            $this->mediaDir = $MediaFolder;
        } else {
            $this->mediaDir = $this->content_folder;
        }
        if($this->mkdir_p($this->mediaDir)){
            return true;
        } else {
            return false;
        }
    }
    /**
     * This function handles the image proccessing
     * @param String $url Path to the file to proccess
     * @param Int $thumb The maximum width of an proccessed image
     * @return String The binary of the image that was created
     * @since 1.0
     */
    function processImage($url, $thumb=0) {
        $tmp0 = imageCreateFromString(fread(fopen($url, "rb"), filesize( $url )));
        if ($tmp0) {
            if($thumb == 0) {
                $dim = Array ('w' => imageSx($tmp0), 'h' => imageSy($tmp0));
            } else {
                if(imagesx($tmp0)<=$thumb){
                    if (imageSy($tmp0) > imageSx($tmp0)){
                        $dim = Array ('w' => imageSx($tmp0), 'h' => imageSy($tmp0));
                    } else {
                        $dim = Array ('w' => imageSx($tmp0), 'h' => imageSy($tmp0));
                    }
                } else {
                    $dim = Array ('w' => $thumb, 'h' => round(imageSy($tmp0)*$thumb/imageSx($tmp0)));
                }
            }
            $tmp1 = imageCreateTrueColor ( $dim [ 'w' ], $dim [ 'h' ] );
            if ( imagecopyresized  ( $tmp1 , $tmp0, 0, 0, 0, 0, $dim [ 'w' ], $dim [ 'h' ], imageSx ( $tmp0 ), imageSy ( $tmp0 ) ) ) {
                imageDestroy ( $tmp0 );
                return $tmp1;
            } else {
                imageDestroy ( $tmp0 );
                imageDestroy ( $tmp1 );
                return $this -> null;
            }
        } else {
            return $this -> null;
        }
    }

    /**
     * This function handles the extraction of the XML file data used to construct the HTML
     * @return Bool True on success
     * @since 1.0
     * @modified 1.2.3
     */
    function extractXML(){
        $xmlFile = $this->tempDir."/word/document.xml";
        $xml = new XMLExtractor();
        $data = $xml->getAllContents($xmlFile);
        $this->contentsInArray = $data;
        $this->output['html'] = array();
//        echo "<pre>";
//        print_r($data);
//        echo "</pre>";
        foreach($data as $key => $row){
            if($row['type'] == 'open') {
                if ($row['tag'] == 'W:P') {
                    $this->openedTag = $key;
                }
            }
            if($row['type'] == 'close') {
                if ($row['tag'] == 'W:P') {
                    $this->closedTag = $key;
                    $paraContent = $this->getParaContent();
                    $stylesArray = $this->getParaStyles();
                    $paraStyles = $this->convertArrayToString($stylesArray);
                    $html = array('<p style="'.$paraStyles.'">'.$paraContent.'</p>');
                    $this->output['html'] = array_merge($this->output['html'], $html);
                }
            }
            if($row['tag'] == "W:PGSZ"){
                $this->pageStyle['width'] = $row['attributes']['W:W']/20 . 'px';
                $this->pageStyle['height'] = $row['attributes']['W:H']/20 . 'px';
            }
            if($row['tag'] == "W:PGMAR"){
                $this->contentStyle['margin-left'] = $row['attributes']['W:LEFT']/20 . 'px';
                $this->contentStyle['margin-right'] = $row['attributes']['W:RIGHT']/20 . 'px';
                $this->contentStyle['margin-top'] = $row['attributes']['W:TOP']/20 . 'px';
                $this->contentStyle['margin-bottom'] = $row['attributes']['W:BOTTOM']/20 . 'px';
                $this->contentStyle['bottom'] = $row['attributes']['W:BOTTOM']/20 . 'px';
                $this->pageHeaderStyle['width'] = $row['attributes']['W:HEADER']/20 . 'px';
                $this->pageHeaderStyle['width'] = $row['attributes']['W:FOOTER']/20 . 'px';
            }
        }
        $defaultStylesArray = $this->getDefaultStyles();
        $this->output['defaultStyle'] = $defaultStylesArray;
        $this->output['contentStyle'] = $this->contentStyle;
        $this->output['pageStyle'] = $this->pageStyle;
        return true;
    }

    function getParaContent(){
        $local = $this->contentsInArray;
        $firstTag = (!empty($this->openedTag)) ? $this->openedTag : 0;
        $lastTag = (!empty($this->closedTag)) ? $this->closedTag : 0;
        $sameLevelArray = array();
        $returnContent = '';
        foreach($local as $key => $row){
            if($key >= $firstTag && $key <= $lastTag){
                array_push($sameLevelArray, $row);
            }
        }
        foreach($sameLevelArray as $key => $row) {
            if($row['tag'] === "W:T") {
                $returnContent .= $row['value'];
            }
            if($row['tag'] == "A:BLIP"){
                $rid = $row['attributes']['R:EMBED'];
                $imagePath = $this->rels[$rid][1];
                $returnContent = "<img style='display:inline;' src='public/".$this->imagePathPrefix.$imagePath."' alt='' />";
            }
        }
        return $returnContent;
    }

    function getParaStyles(){
        $local = $this->contentsInArray;
        $firstTag = (!empty($this->openedTag)) ? $this->openedTag : 0;
        $lastTag = (!empty($this->closedTag)) ? $this->closedTag : 0;
        $sameLevelArray = array();
        $returnStyle = array();
        foreach($local as $key => $row){
            if($key >= $firstTag && $key <= $lastTag){
                array_push($sameLevelArray, $row);
            }
        }
        foreach($sameLevelArray as $key => $row) {
            if($row['tag'] === "W:COLOR") {
                $returnStyle['color'] = '#' . $row['attributes']['W:VAL'];
            }
            if($row['tag'] === "W:SHD") {
                $returnStyle['background-color'] = '#' . $row['attributes']['W:FILL'];
            }
            if($row['tag'] === "W:SZ") {
                $returnStyle['font-size']= $row['attributes']['W:VAL']/2 . 'px';
            }
            if($row['tag'] === "W:SPACING"){
                $returnStyle['something'] = $row['attributes']['W:LINE'];
            }
            if($row['tag'] == "W:B"){
                if(empty($row['attributes']['W:VAL'])) {
                    $returnStyle['font-weight'] = 'bold';
                }
            }
            if($row['tag'] === "W:JC") {
                if($row['attributes']['W:VAL'] != 'both') {
                    $returnStyle['text-align'] = $row['attributes']['W:VAL'];
                }else{
                    $returnStyle['text-align'] = 'justify';
                }
            }
            if($row['tag'] === "W:U") {
                if($row['attributes']['W:VAL'] != 'none') {
                    $returnStyle['text-decoration'] = 'underline';
                }
            }
        }
        return $returnStyle;
    }

    function getDefaultStyles(){
        $xmlFile = $this->tempDir."/word/styles.xml";
        $xml = new XMLExtractor();
        $data = $xml->getAllContents($xmlFile);
        $this->contentsInArray = $data;
        $styles = array();
//        echo "<pre>";
//        print_r($data);
//        echo "</pre>";
        foreach($data as $row){
            if(empty($styles['font-family']) || empty($styles['font']) || empty($styles['font-color']) || empty($styles['font-size'])) {
                if ($row['tag'] == "W:RFONTS") {
                    $styles['font-family'] = $row['attributes']['W:ASCII'];
                    $styles['font'] = $row['attributes']['W:HANSI'];
                }
                if ($row['tag'] == "W:COLOR") {
                    $styles['font-color'] = $row['attributes']['W:VAL'];
                }
                if ($row['tag'] == "W:SZ") {
                    $styles['font-size'] = $row['attributes']['W:VAL']/2;
                }
            }
        }
        return $styles;
    }

    /**
     * Below function takes the style array and returns a styles string
     * @param $styleArray
     * @return string
     */
    function convertArrayToString($styleArray){
        $string = '';
        if(is_array($styleArray)){
            foreach($styleArray as $key => $value){
                $string .= $key.': '.$value.';';
            }
            return $string;
        }else{
            return '';
        }
    }

    /**
     * Recursive directory creation based on full path.
     * Will attempt to set permissions on folders.
     * @param string $target Full path to attempt to create.
     * @return bool Whether the path was created or not. True if path already exists.
     * @since 1.0
     */
    function mkdir_p( $target ) {
        // from php.net/mkdir user contributed notes
        $target = str_replace( '//', '/', $target );
        if ( file_exists( $target ) ){
            return @is_dir( $target );
        }
        // Attempting to create the directory may clutter up our display.
        if ( @mkdir( $target ) ) {
            $stat = @stat( dirname( $target ) );
            $dir_perms = $stat['mode'] & 0007777;  // Get the permission bits.
            @chmod( $target, $dir_perms );
            return true;
        } elseif ( is_dir( dirname( $target ) ) ) {
            return false;
        }
        // If the above failed, attempt to create the parent node, then try again.
        if ( ( $target != '/' ) && ( $this->mkdir_p( dirname( $target ) ) ) ){
            return $this->mkdir_p( $target );
        }
        return false;
    }
    /**
     * This function concludes the class by removing all te temporary files and folders as well as unsetting all variables not required
     * @return Bool True on success
     * @since 1.0
     */
    function DeleteTemps(){
        //this function will delete all the temp files except the word document
        //(.doc) itself. If this was uploaded it will be removed when the
        //script terminates
        if(is_dir($this->tempDir)){
            //the temp directory still exist
            $this->rrmdir($this->tempDir);
            unset($this->content_folder);
            unset($this->docPath);
            unset($this->imagePathPrefix);
            unset($this->image_max_width);
            unset($this->tempDir);
            unset($this->rels);
            unset($this->tagclosep);
            unset($this->tagcloset);
            return true;
        }
        return false;
    }
    /**
     * This function will remove files and directories recursivly
     * @param String $dir The path to the folder to be removed
     */
    function rrmdir($dir) {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            foreach ($objects as $object) {
                if ($object != "." && $object != "..") {
                    if (filetype($dir."/".$object) == "dir"){
                        $this->rrmdir($dir."/".$object);
                    } else {
                        unlink($dir."/".$object);
                    }
                }
            }
            reset($objects);
            rmdir($dir);
        }
    }
}