/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.blobstore;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.blobstore.functions.EnableCDNAndCache;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.blobstore.SwiftBlobStore;
import org.jclouds.openstack.swift.blobstore.functions.BlobStoreListContainerOptionsToListContainerOptions;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceList;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadStrategy;

@Singleton
public class HPCloudObjectStorageBlobStore
extends SwiftBlobStore {
    private EnableCDNAndCache enableCDNAndCache;

    @Inject
    protected HPCloudObjectStorageBlobStore(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, HPCloudObjectStorageApi sync, ContainerToResourceMetadata container2ResourceMd, BlobStoreListContainerOptionsToListContainerOptions container2ContainerListOptions, ContainerToResourceList container2ResourceList, ObjectToBlob object2Blob, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, EnableCDNAndCache enableCDNAndCache, Provider<MultipartUploadStrategy> multipartUploadStrategy) {
        super(userExecutor, context, blobUtils, defaultLocation, locations, (CommonSwiftClient)sync, container2ResourceMd, container2ContainerListOptions, container2ResourceList, object2Blob, blob2Object, object2BlobMd, blob2ObjectGetOptions, fetchBlobMetadataProvider, multipartUploadStrategy);
        this.enableCDNAndCache = enableCDNAndCache;
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        return options.isPublicRead() ? this.enableCDNAndCache.apply(container) != null : this.createContainerInLocation(location, container);
    }
}

