/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Address {
    private final String addr;
    private final int version;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAddress(this);
    }

    public static Address createV4(String addr) {
        return ((Builder)((Builder)Address.builder().version(4)).addr(addr)).build();
    }

    public static Address createV6(String addr) {
        return ((Builder)((Builder)Address.builder().version(6)).addr(addr)).build();
    }

    @ConstructorProperties(value={"addr", "version"})
    protected Address(String addr, int version) {
        this.addr = (String)Preconditions.checkNotNull((Object)addr, (Object)"addr");
        this.version = version;
    }

    public String getAddr() {
        return this.addr;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.addr, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)Address.class.cast(obj);
        return Objects.equal((Object)this.addr, (Object)that.addr) && Objects.equal((Object)this.version, (Object)that.version);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("addr", (Object)this.addr).add("version", this.version);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String addr;
        protected int version;

        protected abstract T self();

        public T addr(String addr) {
            this.addr = addr;
            return this.self();
        }

        public T version(int version) {
            this.version = version;
            return this.self();
        }

        public Address build() {
            return new Address(this.addr, this.version);
        }

        public T fromAddress(Address in) {
            return ((Builder)this.addr(in.getAddr())).version(in.getVersion());
        }
    }
}

