/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.predicates.KeyPairPredicates;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;

@Singleton
public class NovaComputeService
extends BaseComputeService {
    protected final NovaApi novaApi;
    protected final LoadingCache<RegionAndName, SecurityGroupInRegion> securityGroupMap;
    protected final LoadingCache<RegionAndName, KeyPair> keyPairCache;
    protected final Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByRegionId;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    protected NovaComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, NovaApi novaApi, LoadingCache<RegionAndName, SecurityGroupInRegion> securityGroupMap, LoadingCache<RegionAndName, KeyPair> keyPairCache, Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByRegionId, GroupNamingConvention.Factory namingConvention, Optional<ImageExtension> imageExtension, Optional<SecurityGroupExtension> securityGroupExtension) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, userExecutor, imageExtension, securityGroupExtension);
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.securityGroupMap = (LoadingCache)Preconditions.checkNotNull(securityGroupMap, (Object)"securityGroupMap");
        this.keyPairCache = (LoadingCache)Preconditions.checkNotNull(keyPairCache, (Object)"keyPairCache");
        this.orphanedGroupsByRegionId = (Function)Preconditions.checkNotNull(orphanedGroupsByRegionId, (Object)"orphanedGroupsByRegionId");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
    }

    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        Multimap regionToRegionAndGroupNames = (Multimap)this.orphanedGroupsByRegionId.apply(deadNodes);
        for (Map.Entry entry : regionToRegionAndGroupNames.asMap().entrySet()) {
            this.cleanOrphanedGroupsInRegion((Set<String>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())), (String)entry.getKey());
        }
    }

    protected void cleanOrphanedGroupsInRegion(Set<String> groups, String regionId) {
        this.cleanupOrphanedSecurityGroupsInRegion(groups, regionId);
        this.cleanupOrphanedKeyPairsInRegion(groups, regionId);
    }

    private void cleanupOrphanedSecurityGroupsInRegion(Set<String> groups, String regionId) {
        Optional<SecurityGroupApi> securityGroupApi = this.novaApi.getSecurityGroupApi(regionId);
        if (securityGroupApi.isPresent()) {
            for (String group : groups) {
                for (SecurityGroup securityGroup : Iterables.filter(((SecurityGroupApi)securityGroupApi.get()).list(), SecurityGroupPredicates.nameMatches((Predicate<String>)this.namingConvention.create().containsGroup(group)))) {
                    RegionAndName regionAndName = RegionAndName.fromRegionAndName(regionId, securityGroup.getName());
                    this.logger.debug(">> deleting securityGroup(%s)", new Object[]{regionAndName});
                    ((SecurityGroupApi)securityGroupApi.get()).delete(securityGroup.getId());
                    this.securityGroupMap.invalidate((Object)regionAndName);
                    this.logger.debug("<< deleted securityGroup(%s)", new Object[]{regionAndName});
                }
            }
        }
    }

    private void cleanupOrphanedKeyPairsInRegion(Set<String> groups, String regionId) {
        Optional<KeyPairApi> keyPairApi = this.novaApi.getKeyPairApi(regionId);
        if (keyPairApi.isPresent()) {
            for (String group : groups) {
                for (KeyPair pair : ((KeyPairApi)keyPairApi.get()).list().filter(KeyPairPredicates.nameMatches((Predicate<String>)this.namingConvention.create().containsGroup(group)))) {
                    RegionAndName regionAndName = RegionAndName.fromRegionAndName(regionId, pair.getName());
                    this.logger.debug(">> deleting keypair(%s)", new Object[]{regionAndName});
                    ((KeyPairApi)keyPairApi.get()).delete(pair.getName());
                    this.keyPairCache.invalidate((Object)regionAndName);
                    this.logger.debug("<< deleted keypair(%s)", new Object[]{regionAndName});
                }
                this.keyPairCache.invalidate((Object)RegionAndName.fromRegionAndName(regionId, this.namingConvention.create().sharedNameForGroup(group)));
            }
        }
    }

    public NovaTemplateOptions templateOptions() {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.templateOptions());
    }
}

