/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

@Singleton
public class AWSEC2CreateSecurityGroupIfNeeded
extends CacheLoader<RegionAndName, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final AWSSecurityGroupApi securityApi;
    protected final Predicate<RegionAndName> securityGroupEventualConsistencyDelay;
    protected final Function<String, String> groupNameToId;

    @Inject
    public AWSEC2CreateSecurityGroupIfNeeded(AWSEC2Api ec2Api, @Named(value="SECGROUP_NAME_TO_ID") Function<String, String> groupNameToId, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this((AWSSecurityGroupApi)((AWSEC2Api)Preconditions.checkNotNull((Object)ec2Api, (Object)"ec2Api")).getSecurityGroupApi().get(), groupNameToId, securityGroupEventualConsistencyDelay);
    }

    public AWSEC2CreateSecurityGroupIfNeeded(AWSSecurityGroupApi securityApi, @Named(value="SECGROUP_NAME_TO_ID") Function<String, String> groupNameToId, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this.securityApi = (AWSSecurityGroupApi)Preconditions.checkNotNull((Object)securityApi, (Object)"securityApi");
        this.groupNameToId = (Function)Preconditions.checkNotNull(groupNameToId, (Object)"groupNameToId");
        this.securityGroupEventualConsistencyDelay = (Predicate)Preconditions.checkNotNull(securityGroupEventualConsistencyDelay, (Object)"securityGroupEventualConsistencyDelay");
    }

    public String load(RegionAndName from) {
        RegionNameAndIngressRules realFrom = (RegionNameAndIngressRules)RegionNameAndIngressRules.class.cast(from);
        this.createSecurityGroupInRegion(from.getRegion(), from.getName(), realFrom.getPorts());
        return from.getName();
    }

    private void createSecurityGroupInRegion(String region, String name, int ... ports) {
        Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.logger.debug(">> creating securityGroup region(%s) name(%s)", new Object[]{region, name});
        try {
            ImmutableSet perms;
            this.securityApi.createSecurityGroupInRegion(region, name, name);
            boolean created = this.securityGroupEventualConsistencyDelay.apply((Object)new RegionAndName(region, name));
            if (!created) {
                throw new RuntimeException(String.format("security group %s/%s is not available after creating", region, name));
            }
            this.logger.debug("<< created securityGroup(%s)", new Object[]{name});
            ImmutableSet.Builder permissions = ImmutableSet.builder();
            String id = name.startsWith("sg-") ? name : (String)this.groupNameToId.apply((Object)new RegionAndName(region, name).slashEncode());
            if (ports.length > 0) {
                for (Map.Entry range : ComputeServiceUtils.getPortRangesFromList((int[])ports).entrySet()) {
                    permissions.add((Object)IpPermission.builder().fromPort(((Integer)range.getKey()).intValue()).toPort(((Integer)range.getValue()).intValue()).ipProtocol(IpProtocol.TCP).cidrBlock("0.0.0.0/0").build());
                }
                String myOwnerId = ((SecurityGroup)Iterables.get(this.securityApi.describeSecurityGroupsInRegion(region, name), (int)0)).getOwnerId();
                permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.TCP).tenantIdGroupNamePair(myOwnerId, id).build());
                permissions.add((Object)IpPermission.builder().fromPort(0).toPort(65535).ipProtocol(IpProtocol.UDP).tenantIdGroupNamePair(myOwnerId, id).build());
            }
            if (!(perms = permissions.build()).isEmpty()) {
                this.logger.debug(">> authorizing securityGroup region(%s) name(%s) IpPermissions(%s)", new Object[]{region, name, perms});
                this.securityApi.authorizeSecurityGroupIngressInRegion(region, id, (Iterable<IpPermission>)perms);
                this.logger.debug("<< authorized securityGroup(%s)", new Object[]{name});
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{name});
        }
    }
}

