/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.workspaces.AmazonWorkspacesAsync;
import com.amazonaws.services.workspaces.AmazonWorkspacesClient;
import com.amazonaws.services.workspaces.model.CreateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.CreateWorkspacesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebootWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebootWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesResult;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonWorkspacesAsyncClient
extends AmazonWorkspacesClient
implements AmazonWorkspacesAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonWorkspacesAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonWorkspacesAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonWorkspacesAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonWorkspacesAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateWorkspacesResult> createWorkspacesAsync(final CreateWorkspacesRequest createWorkspacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateWorkspacesResult>(){

            @Override
            public CreateWorkspacesResult call() throws Exception {
                return AmazonWorkspacesAsyncClient.this.createWorkspaces(createWorkspacesRequest);
            }
        });
    }

    @Override
    public Future<CreateWorkspacesResult> createWorkspacesAsync(final CreateWorkspacesRequest createWorkspacesRequest, final AsyncHandler<CreateWorkspacesRequest, CreateWorkspacesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateWorkspacesResult>(){

            @Override
            public CreateWorkspacesResult call() throws Exception {
                CreateWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.createWorkspaces(createWorkspacesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createWorkspacesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(final DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeWorkspaceBundlesResult>(){

            @Override
            public DescribeWorkspaceBundlesResult call() throws Exception {
                return AmazonWorkspacesAsyncClient.this.describeWorkspaceBundles(describeWorkspaceBundlesRequest);
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceBundlesResult> describeWorkspaceBundlesAsync(final DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest, final AsyncHandler<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeWorkspaceBundlesResult>(){

            @Override
            public DescribeWorkspaceBundlesResult call() throws Exception {
                DescribeWorkspaceBundlesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.describeWorkspaceBundles(describeWorkspaceBundlesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeWorkspaceBundlesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RebootWorkspacesResult> rebootWorkspacesAsync(final RebootWorkspacesRequest rebootWorkspacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RebootWorkspacesResult>(){

            @Override
            public RebootWorkspacesResult call() throws Exception {
                return AmazonWorkspacesAsyncClient.this.rebootWorkspaces(rebootWorkspacesRequest);
            }
        });
    }

    @Override
    public Future<RebootWorkspacesResult> rebootWorkspacesAsync(final RebootWorkspacesRequest rebootWorkspacesRequest, final AsyncHandler<RebootWorkspacesRequest, RebootWorkspacesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RebootWorkspacesResult>(){

            @Override
            public RebootWorkspacesResult call() throws Exception {
                RebootWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.rebootWorkspaces(rebootWorkspacesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)rebootWorkspacesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(final DescribeWorkspacesRequest describeWorkspacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeWorkspacesResult>(){

            @Override
            public DescribeWorkspacesResult call() throws Exception {
                return AmazonWorkspacesAsyncClient.this.describeWorkspaces(describeWorkspacesRequest);
            }
        });
    }

    @Override
    public Future<DescribeWorkspacesResult> describeWorkspacesAsync(final DescribeWorkspacesRequest describeWorkspacesRequest, final AsyncHandler<DescribeWorkspacesRequest, DescribeWorkspacesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeWorkspacesResult>(){

            @Override
            public DescribeWorkspacesResult call() throws Exception {
                DescribeWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.describeWorkspaces(describeWorkspacesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeWorkspacesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(final DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeWorkspaceDirectoriesResult>(){

            @Override
            public DescribeWorkspaceDirectoriesResult call() throws Exception {
                return AmazonWorkspacesAsyncClient.this.describeWorkspaceDirectories(describeWorkspaceDirectoriesRequest);
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceDirectoriesResult> describeWorkspaceDirectoriesAsync(final DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest, final AsyncHandler<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeWorkspaceDirectoriesResult>(){

            @Override
            public DescribeWorkspaceDirectoriesResult call() throws Exception {
                DescribeWorkspaceDirectoriesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.describeWorkspaceDirectories(describeWorkspaceDirectoriesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeWorkspaceDirectoriesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RebuildWorkspacesResult> rebuildWorkspacesAsync(final RebuildWorkspacesRequest rebuildWorkspacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RebuildWorkspacesResult>(){

            @Override
            public RebuildWorkspacesResult call() throws Exception {
                return AmazonWorkspacesAsyncClient.this.rebuildWorkspaces(rebuildWorkspacesRequest);
            }
        });
    }

    @Override
    public Future<RebuildWorkspacesResult> rebuildWorkspacesAsync(final RebuildWorkspacesRequest rebuildWorkspacesRequest, final AsyncHandler<RebuildWorkspacesRequest, RebuildWorkspacesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RebuildWorkspacesResult>(){

            @Override
            public RebuildWorkspacesResult call() throws Exception {
                RebuildWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.rebuildWorkspaces(rebuildWorkspacesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)rebuildWorkspacesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<TerminateWorkspacesResult> terminateWorkspacesAsync(final TerminateWorkspacesRequest terminateWorkspacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateWorkspacesResult>(){

            @Override
            public TerminateWorkspacesResult call() throws Exception {
                return AmazonWorkspacesAsyncClient.this.terminateWorkspaces(terminateWorkspacesRequest);
            }
        });
    }

    @Override
    public Future<TerminateWorkspacesResult> terminateWorkspacesAsync(final TerminateWorkspacesRequest terminateWorkspacesRequest, final AsyncHandler<TerminateWorkspacesRequest, TerminateWorkspacesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateWorkspacesResult>(){

            @Override
            public TerminateWorkspacesResult call() throws Exception {
                TerminateWorkspacesResult result;
                try {
                    result = AmazonWorkspacesAsyncClient.this.terminateWorkspaces(terminateWorkspacesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)terminateWorkspacesRequest, (Object)result);
                return result;
            }
        });
    }
}

