/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;

public final class Change {
    private final String id;
    private final Status status;
    private final Date submittedAt;

    private Change(String id, Status status, Date submittedAt) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (String)"status for %s", (Object[])new Object[]{id}));
        this.submittedAt = (Date)Preconditions.checkNotNull((Object)submittedAt, (String)"submittedAt for %s", (Object[])new Object[]{id});
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getSubmittedAt() {
        return this.submittedAt;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Change that = (Change)Change.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("status", (Object)this.status).add("submittedAt", (Object)this.submittedAt).toString();
    }

    public static Change create(String id, Status status, Date submittedAt) {
        return new Change(id, status, submittedAt);
    }

    public static enum Status {
        PENDING,
        INSYNC,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf((String)Preconditions.checkNotNull((Object)status, (Object)"status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

