/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.logging.Logger;

@Singleton
public class StandardDriveToWellKnownImage
implements Function<StandardDrive, WellKnownImage> {
    private static final Pattern UNIX_VERSION_PATTERN = Pattern.compile("[^\\d]*(\\d+(?:\\.\\d+)*).*");
    private static final Pattern WINDOWS_VERSION_PATTERN = Pattern.compile("[^\\d]*(\\d+.*)");
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public WellKnownImage apply(StandardDrive input) {
        WellKnownImage.Builder builder = WellKnownImage.builder();
        builder.uuid(input.getUuid());
        builder.size(StandardDriveToWellKnownImage.toGb(input.getSize()));
        builder.description(input.getName());
        OsFamily family = this.extractOsFamily(input.getName());
        String version = this.extractOsVersion(family, input.getName());
        builder.osFamily(family);
        builder.osVersion(version);
        builder.is64bit(StandardDriveToWellKnownImage.is64bit(input.getName()));
        return builder.build();
    }

    private static boolean is64bit(String name) {
        return !name.contains("32bit");
    }

    private OsFamily extractOsFamily(String name) {
        final String lowerCaseName = name.toLowerCase();
        Optional family = Iterables.tryFind(Arrays.asList(OsFamily.values()), (Predicate)new Predicate<OsFamily>(){

            public boolean apply(OsFamily input) {
                return lowerCaseName.startsWith(input.name().toLowerCase());
            }
        });
        if (family.isPresent()) {
            this.logger.warn("could not find the operating system family for image: %s", new Object[]{name});
        }
        return (OsFamily)family.or((Object)OsFamily.UNRECOGNIZED);
    }

    private String extractOsVersion(OsFamily family, String name) {
        String version = null;
        if (family == OsFamily.WINDOWS) {
            Matcher matcher = WINDOWS_VERSION_PATTERN.matcher(name);
            if (matcher.matches()) {
                version = matcher.group(1);
            }
        } else {
            Matcher matcher = UNIX_VERSION_PATTERN.matcher(name);
            if (matcher.matches()) {
                version = matcher.group(1);
            }
        }
        if (version == null) {
            this.logger.warn("could not find the operating system version for image: %s", new Object[]{name});
        }
        return version;
    }

    private static int toGb(long sizeInBytes) {
        return (int)(sizeInBytes / 0x40000000L);
    }
}

