/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;

@Singleton
public class ContainerToResourceList
implements Function<PageSet<ObjectInfo>, PageSet<? extends StorageMetadata>> {
    private final ObjectToBlobMetadata object2blobMd;

    @Inject
    public ContainerToResourceList(ObjectToBlobMetadata object2blobMd) {
        this.object2blobMd = object2blobMd;
    }

    public PageSet<? extends StorageMetadata> apply(PageSet<ObjectInfo> from) {
        return new PageSetImpl(Iterables.transform((Iterable)Iterables.transform(from, (Function)this.object2blobMd), (Function)new Function<BlobMetadata, StorageMetadata>(){

            public StorageMetadata apply(BlobMetadata input) {
                if (input.getContentMetadata().getContentType().equals("application/directory")) {
                    return new StorageMetadataImpl(StorageType.RELATIVE_PATH, input.getProviderId(), input.getName(), input.getLocation(), input.getUri(), input.getETag(), input.getCreationDate(), input.getLastModified(), input.getUserMetadata());
                }
                return input;
            }
        }), from.getNextMarker());
    }
}

