/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.Invokable;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.util.List;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.TemporaryUrlKey;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.util.Strings2;

@Singleton
public class SwiftBlobSigner<T extends CommonSwiftClient>
implements BlobRequestSigner {
    private final Function<Invocation, HttpRequest> processor;
    private final Crypto crypto;
    private final Provider<Long> unixEpochTimestampProvider;
    private final Supplier<String> temporaryUrlKeySupplier;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Invokable<?, ?> getMethod;
    private final Invokable<?, ?> deleteMethod;
    private final Invokable<?, ?> createMethod;

    @Inject
    protected SwiftBlobSigner(BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Crypto crypto, @TimeStamp Provider<Long> unixEpochTimestampProvider, @TemporaryUrlKey Supplier<String> temporaryUrlKeySupplier, Function<Invocation, HttpRequest> processor, Class<T> ownerType) throws SecurityException, NoSuchMethodException {
        this.processor = (Function)Preconditions.checkNotNull(processor, (Object)"processor");
        this.crypto = (Crypto)Preconditions.checkNotNull((Object)crypto, (Object)"crypto");
        this.unixEpochTimestampProvider = (Provider)Preconditions.checkNotNull(unixEpochTimestampProvider, (Object)"unixEpochTimestampProvider");
        this.temporaryUrlKeySupplier = (Supplier)Preconditions.checkNotNull(temporaryUrlKeySupplier, (Object)"temporaryUrlKeyProvider");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.getMethod = Reflection2.method(ownerType, (String)"getObject", (Class[])new Class[]{String.class, String.class, GetOptions[].class});
        this.deleteMethod = Reflection2.method(ownerType, (String)"removeObject", (Class[])new Class[]{String.class, String.class});
        this.createMethod = Reflection2.method(ownerType, (String)"putObject", (Class[])new Class[]{String.class, SwiftObject.class});
    }

    public HttpRequest signGetBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name)))));
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        HttpRequest request = (HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name)));
        return BlobStoreUtils.cleanRequest((HttpRequest)this.signForTemporaryAccess(request, timeInSeconds));
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name, (Object)this.blob2HttpGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options")))))));
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob))))));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        HttpRequest request = (HttpRequest)this.processor.apply((Object)Invocation.create(this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob))));
        return BlobStoreUtils.cleanRequest((HttpRequest)this.signForTemporaryAccess(request, timeInSeconds));
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.deleteMethod, (List)ImmutableList.of((Object)container, (Object)name)))));
    }

    private HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        HttpRequest.Builder builder = request.toBuilder().filters((Iterable)ImmutableSet.of());
        String key = (String)this.temporaryUrlKeySupplier.get();
        if (key == null) {
            throw new UnsupportedOperationException();
        }
        long expiresInSeconds = (Long)this.unixEpochTimestampProvider.get() + timeInSeconds;
        builder.addQueryParam("temp_url_sig", new String[]{this.createSignature(key, this.createStringToSign(request.getMethod().toUpperCase(), request, expiresInSeconds))});
        builder.addQueryParam("temp_url_expires", new String[]{"" + expiresInSeconds});
        return builder.build();
    }

    private String createStringToSign(String method, HttpRequest request, long expiresInSeconds) {
        Preconditions.checkArgument((method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("PUT") ? 1 : 0) != 0);
        return String.format("%s\n%d\n%s", method.toUpperCase(), expiresInSeconds, request.getEndpoint().getPath());
    }

    private String createSignature(String key, String toSign) {
        try {
            ByteProcessor hmacSHA1 = Macs.asByteProcessor((Mac)this.crypto.hmacSHA1(key.getBytes(Charsets.UTF_8)));
            return BaseEncoding.base16().lowerCase().encode((byte[])ByteStreams.readBytes((InputStream)Strings2.toInputStream((String)toSign), (ByteProcessor)hmacSHA1));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

