/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class ParseCookbookDefinitionFromJsonv10
implements Function<HttpResponse, CookbookDefinition> {
    private final ParseJson<Map<String, CookbookDefinition>> parser;

    @Inject
    ParseCookbookDefinitionFromJsonv10(ParseJson<Map<String, CookbookDefinition>> parser) {
        this.parser = parser;
    }

    public CookbookDefinition apply(HttpResponse response) {
        Map result = (Map)this.parser.apply(response);
        String cookbookName = (String)result.keySet().iterator().next();
        CookbookDefinition def = (CookbookDefinition)result.values().iterator().next();
        return CookbookDefinition.builder().from(def).name(cookbookName).build();
    }
}

