/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.ParameterNameValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyCacheParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cacheParameterGroupName;
    private ListWithAutoConstructFlag<ParameterNameValue> parameterNameValues;

    public ModifyCacheParameterGroupRequest() {
    }

    public ModifyCacheParameterGroupRequest(String cacheParameterGroupName, List<ParameterNameValue> parameterNameValues) {
        this.setCacheParameterGroupName(cacheParameterGroupName);
        this.setParameterNameValues(parameterNameValues);
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public ModifyCacheParameterGroupRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        return this;
    }

    public List<ParameterNameValue> getParameterNameValues() {
        if (this.parameterNameValues == null) {
            this.parameterNameValues = new ListWithAutoConstructFlag();
            this.parameterNameValues.setAutoConstruct(true);
        }
        return this.parameterNameValues;
    }

    public void setParameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
        if (parameterNameValues == null) {
            this.parameterNameValues = null;
            return;
        }
        ListWithAutoConstructFlag parameterNameValuesCopy = new ListWithAutoConstructFlag(parameterNameValues.size());
        parameterNameValuesCopy.addAll(parameterNameValues);
        this.parameterNameValues = parameterNameValuesCopy;
    }

    public ModifyCacheParameterGroupRequest withParameterNameValues(ParameterNameValue ... parameterNameValues) {
        if (this.getParameterNameValues() == null) {
            this.setParameterNameValues(new ArrayList<ParameterNameValue>(parameterNameValues.length));
        }
        for (ParameterNameValue value : parameterNameValues) {
            this.getParameterNameValues().add(value);
        }
        return this;
    }

    public ModifyCacheParameterGroupRequest withParameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
        if (parameterNameValues == null) {
            this.parameterNameValues = null;
        } else {
            ListWithAutoConstructFlag parameterNameValuesCopy = new ListWithAutoConstructFlag(parameterNameValues.size());
            parameterNameValuesCopy.addAll(parameterNameValues);
            this.parameterNameValues = parameterNameValuesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: " + this.getCacheParameterGroupName() + ",");
        }
        if (this.getParameterNameValues() != null) {
            sb.append("ParameterNameValues: " + this.getParameterNameValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getParameterNameValues() == null ? 0 : this.getParameterNameValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheParameterGroupRequest)) {
            return false;
        }
        ModifyCacheParameterGroupRequest other = (ModifyCacheParameterGroupRequest)obj;
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getParameterNameValues() == null ^ this.getParameterNameValues() == null) {
            return false;
        }
        return other.getParameterNameValues() == null || other.getParameterNameValues().equals(this.getParameterNameValues());
    }

    public ModifyCacheParameterGroupRequest clone() {
        return (ModifyCacheParameterGroupRequest)super.clone();
    }
}

